/*
 * Decompiled with CFR 0.152.
 */
package com.logicartisan.common.core.listeners;

import com.logicartisan.common.core.listeners.ListenerDispatchControl;
import com.logicartisan.common.core.listeners.ListenerFilter;
import com.logicartisan.common.core.listeners.ListenerSupport;
import com.logicartisan.common.core.listeners.MessageDeliveryErrorHandler;
import com.logicartisan.common.core.thread.NamingThreadFactory;
import com.logicartisan.common.core.thread.ScheduledExecutor;
import com.logicartisan.common.core.thread.ThreadKit;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ListenerSupportImpl<T, A>
implements ListenerSupport<T, A>,
InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ListenerSupportImpl.class);
    private static final int CORE_POOL_SIZE;
    private static final long KEEP_ALIVE_TIME;
    static final Executor SHARED_NOTIFICATION_POOL;
    private final Executor executor;
    private final MessageDeliveryErrorHandler<T> error_handler;
    private final int max_message_backlog;
    private final T dispatcher;
    private final long delay;
    private final TimeUnit delay_unit;
    private final Map<T, ListenerDispatchControl<T, A>> listener_info_map = new HashMap<T, ListenerDispatchControl<T, A>>();
    private final Lock listener_info_map_lock = new ReentrantLock();
    private final AtomicReference<ListenerFilter<A>> filter_reference = new AtomicReference();
    private final ListenerDispatchControl.RemoveSupport<T> remove_support = this::remove;

    ListenerSupportImpl(Class<T> listener_class, Executor executor, MessageDeliveryErrorHandler<T> error_handler, int max_message_backlog, long delay, TimeUnit delay_unit) {
        this.executor = executor;
        this.error_handler = error_handler;
        this.max_message_backlog = max_message_backlog;
        this.delay = delay;
        this.delay_unit = delay_unit;
        this.dispatcher = Proxy.newProxyInstance(listener_class.getClassLoader(), new Class[]{listener_class}, (InvocationHandler)this);
    }

    @Override
    public void add(T listener) {
        this.add(listener, null);
    }

    @Override
    public void add(T listener, A attachment) {
        Objects.requireNonNull(listener);
        this.listener_info_map_lock.lock();
        try {
            if (this.listener_info_map.containsKey(listener)) {
                return;
            }
            this.listener_info_map.put(listener, new ListenerDispatchControl<T, A>(listener, this.max_message_backlog, this.error_handler, this.remove_support, attachment, this.filter_reference));
        }
        finally {
            this.listener_info_map_lock.unlock();
        }
    }

    @Override
    public boolean remove(T listener) {
        Objects.requireNonNull(listener);
        this.listener_info_map_lock.lock();
        try {
            this.listener_info_map.remove(listener);
            boolean bl = this.listener_info_map.isEmpty();
            return bl;
        }
        finally {
            this.listener_info_map_lock.unlock();
        }
    }

    @Override
    public void removeAllListeners() {
        this.listener_info_map_lock.lock();
        try {
            this.listener_info_map.clear();
        }
        finally {
            this.listener_info_map_lock.unlock();
        }
    }

    @Override
    public boolean hasListeners() {
        this.listener_info_map_lock.lock();
        try {
            boolean bl = !this.listener_info_map.isEmpty();
            return bl;
        }
        finally {
            this.listener_info_map_lock.unlock();
        }
    }

    @Override
    public T dispatch() {
        return this.dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public A getAttachment(T listener) {
        this.listener_info_map_lock.lock();
        try {
            ListenerDispatchControl<T, A> ldc = this.listener_info_map.get(listener);
            if (ldc == null) {
                A a = null;
                return a;
            }
            A a = ldc.getAttachment();
            return a;
        }
        finally {
            this.listener_info_map_lock.unlock();
        }
    }

    @Override
    public void setListenerFilter(ListenerFilter<A> listener_filter) {
        this.filter_reference.set(listener_filter);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getReturnType() == Void.TYPE) {
            if (this.delay > 0L) {
                if (this.executor instanceof ScheduledExecutor) {
                    ((ScheduledExecutor)this.executor).schedule(() -> this.dispatchMethodInvoke(method, args), this.delay, this.delay_unit);
                } else {
                    this.executor.execute(() -> {
                        ThreadKit.sleep(this.delay, this.delay_unit);
                        this.dispatchMethodInvoke(method, args);
                    });
                }
                return null;
            }
            this.dispatchMethodInvoke(method, args);
            return null;
        }
        throw new UnsupportedOperationException("The method \"" + method.getName() + "\" does not return null and so may not be dispatched.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchMethodInvoke(Method method, Object[] args) {
        ListenerDispatchControl[] listener_handlers;
        this.listener_info_map_lock.lock();
        try {
            listener_handlers = new ListenerDispatchControl[this.listener_info_map.size()];
            this.listener_info_map.values().toArray(listener_handlers);
        }
        finally {
            this.listener_info_map_lock.unlock();
        }
        for (ListenerDispatchControl listener_handler : listener_handlers) {
            if (!listener_handler.postMessageInfoToQueue(method, args)) continue;
            boolean abend = true;
            try {
                this.executor.execute(listener_handler);
                abend = false;
            }
            catch (Throwable t) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Unable to start worker thread to post message: {} (args={}", new Object[]{method, Arrays.toString(args), t});
            }
            finally {
                if (abend) {
                    listener_handler.indicateWorkerThreadStartFailure();
                }
            }
        }
    }

    static {
        try {
            long default_delay = Long.getLong("com.starlight.listeners.default_message_delay", 0L);
            if (default_delay > 0L) {
                LOG.warn("Default delay is active for ListenerSupport: {} ms", (Object)default_delay);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        CORE_POOL_SIZE = Integer.getInteger("com.starlight.listeners.core_pool_size", 3);
        KEEP_ALIVE_TIME = Long.getLong("com.starlight.listeners.keep_alive_time", 10000L);
        SHARED_NOTIFICATION_POOL = new ThreadPoolExecutor(CORE_POOL_SIZE, Integer.MAX_VALUE, KEEP_ALIVE_TIME, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new NamingThreadFactory("ListenerSupport Notifier", true));
    }
}

