/*
 * Decompiled with CFR 0.152.
 */
package com.logicartisan.common.core.thread;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ObjectSlot<V>
implements Supplier<V>,
Consumer<V> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition new_value_condition = this.lock.newCondition();
    private List<ConsumerFuture<V>> single_value_consumers;
    private List<ConsumerFuture<Optional<V>>> persistent_value_consumers;
    private volatile V value;

    public ObjectSlot() {
        this(null);
    }

    public ObjectSlot(V value) {
        this.value = value;
    }

    @Override
    public void accept(V value) {
        this.set(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareAndSet(V expect, V update) {
        this.lock.lock();
        try {
            if (!Objects.equals(this.value, expect)) {
                boolean bl = false;
                return bl;
            }
            this.getAndSet_noLock(update);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareAndSet(@Nonnull Predicate<V> update_allowed_test, V update) {
        this.lock.lock();
        try {
            if (!update_allowed_test.test(this.value)) {
                boolean bl = false;
                return bl;
            }
            this.getAndSet_noLock(update);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Nullable
    public V get() {
        this.lock.lock();
        try {
            V v = this.value;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    public V getAndSet(@Nullable V new_value) {
        this.lock.lock();
        try {
            V v = this.getAndSet_noLock(new_value);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void set(@Nullable V new_value) {
        this.lock.lock();
        try {
            this.getAndSet_noLock(new_value);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.set(null);
    }

    public V waitForValue() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            if (this.value != null) {
                V v = this.value;
                return v;
            }
            while (this.value == null) {
                this.new_value_condition.await();
            }
            V v = this.value;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V waitForValue(long timeout_ms) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            long start;
            if (this.value != null) {
                V v = this.value;
                return v;
            }
            for (long wait_remaining = timeout_ms; this.value == null && wait_remaining > 0L; wait_remaining -= System.currentTimeMillis() - start) {
                start = System.currentTimeMillis();
                boolean have_new_value = this.new_value_condition.await(wait_remaining, TimeUnit.MILLISECONDS);
                if (have_new_value) continue;
                V v = null;
                return v;
            }
            V v = this.value;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForValue(V value, long timeout_ms) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            long start;
            for (long wait_remaining = timeout_ms; !Objects.equals(this.value, value) && wait_remaining > 0L; wait_remaining -= System.currentTimeMillis() - start) {
                start = System.currentTimeMillis();
                boolean have_new_value = this.new_value_condition.await(wait_remaining, TimeUnit.MILLISECONDS);
                if (have_new_value) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = Objects.equals(this.value, value);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V waitForDifferentValue(V value, long timeout_ms) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            long start;
            for (long wait_remaining = timeout_ms; Objects.equals(this.value, value) && wait_remaining > 0L; wait_remaining -= System.currentTimeMillis() - start) {
                start = System.currentTimeMillis();
                boolean have_new_value = this.new_value_condition.await(wait_remaining, TimeUnit.MILLISECONDS);
                if (have_new_value) continue;
                V v = value;
                return v;
            }
            V new_value = this.value;
            if (Objects.equals(new_value, value)) {
                V v = value;
                return v;
            }
            V v = new_value;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Future<V> consumeValue(@Nonnull Consumer<V> value_consumer) {
        this.lock.lock();
        try {
            Future<V> future2 = ObjectSlot.handleValueConsumer(value_consumer, () -> {
                assert (this.lock.isHeldByCurrentThread());
                if (this.single_value_consumers == null) {
                    this.single_value_consumers = new ArrayList<ConsumerFuture<V>>();
                }
                return this.single_value_consumers;
            }, this.value, false, this.lock, future -> {
                assert (this.lock.isHeldByCurrentThread());
                if (this.single_value_consumers == null) {
                    return false;
                }
                boolean removed = this.single_value_consumers.remove(future);
                if (this.single_value_consumers.isEmpty()) {
                    this.single_value_consumers = null;
                }
                return removed;
            });
            return future2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nonnull
    public Future<Optional<V>> consumeAllValues(@Nonnull Consumer<Optional<V>> value_consumer) {
        this.lock.lock();
        try {
            Future<Optional<V>> future2 = ObjectSlot.handleValueConsumer(value_consumer, () -> {
                if (this.persistent_value_consumers == null) {
                    this.persistent_value_consumers = new ArrayList<ConsumerFuture<Optional<V>>>();
                }
                return this.persistent_value_consumers;
            }, Optional.ofNullable(this.value), true, this.lock, future -> {
                assert (this.lock.isHeldByCurrentThread());
                if (this.persistent_value_consumers == null) {
                    return false;
                }
                boolean removed = this.persistent_value_consumers.remove(future);
                if (this.persistent_value_consumers.isEmpty()) {
                    this.persistent_value_consumers = null;
                }
                return removed;
            });
            return future2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static <T> Future<T> handleValueConsumer(@Nonnull Consumer<T> consumer, @Nonnull Supplier<List<ConsumerFuture<T>>> list_supplier, @Nullable T current_value, boolean persistent, @Nonnull Lock lock, @Nonnull Predicate<ConsumerFuture<T>> cancel_handler) {
        Objects.requireNonNull(consumer);
        Objects.requireNonNull(list_supplier);
        if (!persistent && current_value != null) {
            consumer.accept(current_value);
            return new ImmediateFuture<T>(current_value);
        }
        List<ConsumerFuture<T>> list = list_supplier.get();
        ConsumerFuture<T> future = new ConsumerFuture<T>(consumer, lock, cancel_handler);
        list.add(future);
        if (persistent) {
            Objects.requireNonNull(current_value);
            future.setValue(current_value);
        }
        return future;
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    private V getAndSet_noLock(@Nullable V new_value) {
        assert (this.lock.isHeldByCurrentThread());
        V old_value = this.value;
        this.value = new_value;
        this.new_value_condition.signalAll();
        this.processConsumers(new_value);
        return old_value;
    }

    private void processConsumers(@Nullable V value) {
        assert (this.lock.isHeldByCurrentThread());
        if (value != null && this.single_value_consumers != null) {
            for (int i = this.single_value_consumers.size() - 1; i >= 0; --i) {
                ConsumerFuture<Optional<V>> future = this.single_value_consumers.remove(i);
                future.setValue((Optional<V>)value);
            }
        }
        if (this.persistent_value_consumers != null) {
            for (ConsumerFuture<Optional<V>> future : this.persistent_value_consumers) {
                future.setValue(Optional.ofNullable(value));
            }
        }
    }

    private static class ConsumerFuture<FV>
    implements Future<FV> {
        private final Consumer<FV> consumer;
        private final Lock lock;
        private final Predicate<ConsumerFuture<FV>> cancel_handler;
        private final ObjectSlot<FV> inner_slot = new ObjectSlot();
        private volatile boolean cancelled = false;

        ConsumerFuture(@Nonnull Consumer<FV> consumer, @Nonnull Lock lock, @Nonnull Predicate<ConsumerFuture<FV>> cancel_handler) {
            this.consumer = Objects.requireNonNull(consumer);
            this.lock = Objects.requireNonNull(lock);
            this.cancel_handler = Objects.requireNonNull(cancel_handler);
        }

        void setValue(@Nonnull FV value) {
            this.inner_slot.set(value);
            this.consumer.accept(value);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.lock.lock();
            try {
                this.cancelled = true;
                boolean bl = this.cancel_handler.test(this);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.inner_slot.get() != null;
        }

        @Override
        public FV get() throws InterruptedException, ExecutionException {
            return this.inner_slot.waitForValue();
        }

        @Override
        public FV get(long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.inner_slot.waitForValue(unit.toMillis(timeout));
        }
    }

    private static class ImmediateFuture<V>
    implements Future<V> {
        private final V value;

        ImmediateFuture(V value) {
            this.value = value;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public V get(long timeout, @Nonnull TimeUnit unit) {
            return this.value;
        }
    }
}

