/*
 * Decompiled with CFR 0.152.
 */
package com.logicartisan.common.core.thread;

import com.logicartisan.common.core.thread.NamingThreadFactory;
import com.logicartisan.common.core.thread.ObjectSlot;
import com.logicartisan.common.core.thread.ScheduledExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedThreadPool
implements Executor,
ScheduledExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(SharedThreadPool.class);
    private static final long THREAD_CACHE_TIME = Long.getLong("starlight.sharedthreadpool.cache_time", 60000L);
    public static final SharedThreadPool INSTANCE = new SharedThreadPool();
    private final ScheduledThreadPoolExecutor schedule_executor = new ScheduledThreadPoolExecutor(1, new NamingThreadFactory("SharedThreadPool Scheduler"));
    private final ExecutorService main_executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, THREAD_CACHE_TIME, TimeUnit.MILLISECONDS, new SynchronousQueue(), new NameStoringThreadNamingThreadFactory("SharedThreadPool Worker-")){

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (Thread.currentThread() instanceof NameStoringThread) {
                ((NameStoringThread)Thread.currentThread()).restoreOriginalName();
            }
            if (t != null) {
                LOG.warn("Execution of task ({}) threw uncaught exception", (Object)r, (Object)t);
            }
            super.afterExecute(r, t);
        }
    };

    private SharedThreadPool() {
    }

    @Override
    public void execute(@Nonnull Runnable command) {
        LOG.debug("Execute: {}", (Object)command);
        this.main_executor.submit(command);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Schedule: {} at delay={} {}", new Object[]{callable, delay, unit});
        }
        HandoffScheduledFuture<V> handoff_future = new HandoffScheduledFuture<V>();
        HandoffCallable<V> wrapper = new HandoffCallable<V>(callable, handoff_future, this.main_executor);
        ScheduledFuture<V> schedule_future = this.schedule_executor.schedule(wrapper, delay, unit);
        handoff_future.init(schedule_future);
        return handoff_future;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Schedule: {} at delay={} {}", new Object[]{command, delay, unit});
        }
        HandoffScheduledFuture handoff_future = new HandoffScheduledFuture();
        HandoffRunnable wrapper = new HandoffRunnable(command, handoff_future, this.main_executor);
        ScheduledFuture<?> schedule_future = this.schedule_executor.schedule(wrapper, delay, unit);
        handoff_future.init(schedule_future);
        return handoff_future;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Schedule at fixed rate: {} at initialDelay={} period={} {}", new Object[]{command, initialDelay, period, unit});
        }
        HandoffScheduledFuture handoff_future = new HandoffScheduledFuture();
        PreventConcurrentRunHandoffRunnable wrapper = new PreventConcurrentRunHandoffRunnable(command, handoff_future, this.main_executor);
        ScheduledFuture<?> schedule_future = this.schedule_executor.scheduleAtFixedRate(wrapper, initialDelay, period, unit);
        handoff_future.init(schedule_future);
        return handoff_future;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Schedule with fixed delay: {} at initialDelay={} delay={} {}", new Object[]{command, initialDelay, delay, unit});
        }
        RescheduleWrapperRunnable reschedule_wrapper = new RescheduleWrapperRunnable(command, delay, unit, this.schedule_executor);
        HandoffScheduledFuture handoff_future = new HandoffScheduledFuture();
        HandoffRunnable wrapper = new HandoffRunnable(reschedule_wrapper, handoff_future, this.main_executor);
        reschedule_wrapper.initHandoffRunnable(wrapper, handoff_future);
        ScheduledFuture<?> schedule_future = this.schedule_executor.schedule(wrapper, initialDelay, unit);
        handoff_future.init(schedule_future);
        return handoff_future;
    }

    private class TrackingRunnableWrapper
    implements Runnable {
        final AtomicBoolean running = new AtomicBoolean(false);
        private final Runnable delegate;

        TrackingRunnableWrapper(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            this.running.set(true);
            try {
                this.delegate.run();
            }
            finally {
                this.running.set(false);
            }
        }
    }

    private class PreventConcurrentRunHandoffRunnable
    extends HandoffRunnable {
        PreventConcurrentRunHandoffRunnable(Runnable delegate, HandoffScheduledFuture<?> handoff_future, ExecutorService main_executor) {
            super(new TrackingRunnableWrapper(delegate), handoff_future, main_executor);
        }

        @Override
        public void run() {
            TrackingRunnableWrapper wrapper = (TrackingRunnableWrapper)this.delegate;
            boolean currently_running = wrapper.running.get();
            if (currently_running) {
                return;
            }
            super.run();
        }
    }

    private class NameStoringThreadNamingThreadFactory
    extends NamingThreadFactory {
        public NameStoringThreadNamingThreadFactory(String name_prefix) {
            super(name_prefix);
        }

        @Override
        protected Thread createThread(Runnable r, String name) {
            return new NameStoringThread(r, name);
        }
    }

    private class NameStoringThread
    extends Thread {
        private final String original_name;

        public NameStoringThread(Runnable target, String name) {
            super(target, name);
            this.original_name = name;
        }

        public void restoreOriginalName() {
            this.setName(this.original_name);
        }
    }

    private static class HandoffScheduledFuture<V>
    implements ScheduledFuture<V> {
        private ScheduledFuture<V> scheduled_delegate;
        private ObjectSlot<Future<V>> direct_execution_delegate = new ObjectSlot();

        HandoffScheduledFuture() {
        }

        void init(ScheduledFuture<V> scheduled_delegate) {
            ScheduledFuture<V> previous_delegate = this.scheduled_delegate;
            this.scheduled_delegate = scheduled_delegate;
            if (previous_delegate != null && previous_delegate.isCancelled()) {
                scheduled_delegate.cancel(false);
            }
        }

        void setDirectExecutionDelegate(Future<V> direct_execution_delegate) {
            this.direct_execution_delegate.set(direct_execution_delegate);
        }

        @Override
        public long getDelay(@Nonnull TimeUnit unit) {
            return this.scheduled_delegate.getDelay(unit);
        }

        @Override
        public int compareTo(@Nonnull Delayed o) {
            return this.scheduled_delegate.compareTo(o);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean canceled = this.scheduled_delegate.cancel(mayInterruptIfRunning);
            Future<V> direct_future = this.direct_execution_delegate.get();
            if (direct_future != null) {
                canceled |= direct_future.cancel(mayInterruptIfRunning);
            }
            return canceled;
        }

        @Override
        public boolean isCancelled() {
            Future<V> direct_future = this.direct_execution_delegate.get();
            if (direct_future == null) {
                return this.scheduled_delegate.isCancelled();
            }
            return direct_future.isCancelled();
        }

        @Override
        public boolean isDone() {
            Future<V> direct_future = this.direct_execution_delegate.get();
            return direct_future != null && direct_future.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            Future<V> direct_future = this.direct_execution_delegate.waitForValue();
            return direct_future.get();
        }

        @Override
        public V get(long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long start = System.nanoTime();
            Future<V> direct_future = this.direct_execution_delegate.waitForValue(unit.toMillis(timeout));
            long spent = Math.min(0L, System.nanoTime() - start);
            long remaining = unit.toNanos(timeout) - spent;
            if (remaining <= 0L) {
                return direct_future.get(0L, unit);
            }
            return direct_future.get(remaining, TimeUnit.NANOSECONDS);
        }
    }

    private static class HandoffCallable<V>
    implements Callable<V> {
        private final Callable<V> delegate;
        private final HandoffScheduledFuture<V> handoff_future;
        private final ExecutorService main_executor;

        HandoffCallable(Callable<V> delegate, HandoffScheduledFuture<V> handoff_future, ExecutorService main_executor) {
            this.delegate = delegate;
            this.handoff_future = handoff_future;
            this.main_executor = main_executor;
        }

        @Override
        public V call() throws Exception {
            Future<V> inner_future = this.main_executor.submit(this.delegate);
            this.handoff_future.setDirectExecutionDelegate(inner_future);
            return null;
        }
    }

    private static class HandoffRunnable
    implements Runnable {
        protected final Runnable delegate;
        private final HandoffScheduledFuture<?> handoff_future;
        private final ExecutorService main_executor;

        HandoffRunnable(Runnable delegate, HandoffScheduledFuture<?> handoff_future, ExecutorService main_executor) {
            this.delegate = delegate;
            this.handoff_future = handoff_future;
            this.main_executor = main_executor;
        }

        @Override
        public void run() {
            Future<?> inner_future = this.main_executor.submit(this.delegate);
            this.handoff_future.setDirectExecutionDelegate(inner_future);
        }
    }

    private static class RescheduleWrapperRunnable
    implements Runnable {
        private final Runnable delegate;
        private final long delay;
        private final TimeUnit unit;
        private final ScheduledThreadPoolExecutor schedule_executor;
        private HandoffRunnable handoff_runnable;
        private HandoffScheduledFuture<?> handoff_future;

        RescheduleWrapperRunnable(Runnable delegate, long delay, TimeUnit unit, ScheduledThreadPoolExecutor schedule_executor) {
            this.delegate = delegate;
            this.delay = delay;
            this.unit = unit;
            this.schedule_executor = schedule_executor;
        }

        void initHandoffRunnable(HandoffRunnable handoff_runnable, HandoffScheduledFuture<?> handoff_future) {
            this.handoff_runnable = handoff_runnable;
            this.handoff_future = handoff_future;
        }

        @Override
        public void run() {
            this.delegate.run();
            if (this.handoff_future.isCancelled()) {
                return;
            }
            ScheduledFuture<?> future = this.schedule_executor.schedule(this.handoff_runnable, this.delay, this.unit);
            this.handoff_future.init(future);
        }
    }
}

