/*
 * Decompiled with CFR 0.152.
 */
package com.logicartisan.common.core.thread;

import com.logicartisan.common.core.thread.SharedThreadPool;
import com.logicartisan.common.core.thread.ThreadKit;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class SingleThreadRepeatingTask
implements Runnable {
    private final Executor executor;
    private final Runnable action;
    private final Consumer<Throwable> error_handler;
    private final Runnable inner_runner = new InnerRunner();
    private final Lock logic_lock = new ReentrantLock();
    private volatile boolean run_requested = false;
    private volatile boolean thread_running = false;

    public SingleThreadRepeatingTask(@Nonnull Executor executor, @Nonnull Runnable action) {
        this(executor, action, Throwable::printStackTrace);
    }

    public SingleThreadRepeatingTask(@Nonnull Executor executor, @Nonnull Runnable action, @Nonnull Consumer<Throwable> error_handler) {
        this.executor = Objects.requireNonNull(executor);
        this.action = Objects.requireNonNull(action);
        this.error_handler = Objects.requireNonNull(error_handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean should_run_task = false;
        this.logic_lock.lock();
        try {
            this.run_requested = true;
            if (!this.thread_running) {
                this.thread_running = true;
                should_run_task = true;
            }
        }
        finally {
            this.logic_lock.unlock();
        }
        if (should_run_task) {
            boolean abend = true;
            try {
                this.executor.execute(this.inner_runner);
                abend = false;
            }
            finally {
                if (abend) {
                    this.logic_lock.lock();
                    try {
                        this.thread_running = false;
                    }
                    finally {
                        this.logic_lock.unlock();
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        AtomicInteger counter = new AtomicInteger(0);
        SingleThreadRepeatingTask task = new SingleThreadRepeatingTask(SharedThreadPool.INSTANCE, () -> {
            System.out.println("Run: " + counter.getAndIncrement());
            ThreadKit.sleep(1000L);
        });
        while (true) {
            for (int i = 0; i < 15; ++i) {
                task.run();
                ThreadKit.sleep(100L);
            }
            System.out.println("   Long sleep");
            ThreadKit.sleep(5000L);
        }
    }

    private class InnerRunner
    implements Runnable {
        private InnerRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean run_again = false;
            do {
                try {
                    SingleThreadRepeatingTask.this.run_requested = false;
                    SingleThreadRepeatingTask.this.action.run();
                }
                catch (Throwable t) {
                    SingleThreadRepeatingTask.this.error_handler.accept(t);
                }
                finally {
                    SingleThreadRepeatingTask.this.logic_lock.lock();
                    try {
                        if (SingleThreadRepeatingTask.this.run_requested) {
                            SingleThreadRepeatingTask.this.run_requested = false;
                            run_again = true;
                        } else {
                            SingleThreadRepeatingTask.this.thread_running = false;
                            run_again = false;
                        }
                    }
                    finally {
                        SingleThreadRepeatingTask.this.logic_lock.unlock();
                    }
                }
            } while (run_again);
        }
    }
}

