/*
 * Decompiled with CFR 0.152.
 */
package com.logicartisan.common.core.thread;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class ThreadKit {
    private ThreadKit() {
    }

    public static boolean sleep(long time_ms) {
        return ThreadKit.sleep(time_ms, TimeUnit.MILLISECONDS);
    }

    public static boolean sleep(long time, @Nonnull TimeUnit unit) {
        try {
            long millis = unit.toMillis(time);
            Thread.sleep(millis);
            return true;
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    public static void inLock(@Nonnull Lock lock, @Nonnull Runnable action) {
        lock.lock();
        try {
            action.run();
        }
        finally {
            lock.unlock();
        }
    }

    public static <T> T inLock(@Nonnull Lock lock, @Nonnull Supplier<T> supplier) {
        lock.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public static void inReadLock(@Nonnull ReadWriteLock lock, @Nonnull Runnable action) {
        ThreadKit.inLock(lock.readLock(), action);
    }

    public static <T> T inReadLock(@Nonnull ReadWriteLock lock, @Nonnull Supplier<T> supplier) {
        return ThreadKit.inLock(lock.readLock(), supplier);
    }

    public static void inWriteLock(@Nonnull ReadWriteLock lock, @Nonnull Runnable action) {
        ThreadKit.inLock(lock.writeLock(), action);
    }

    public static <T> T inWriteLock(@Nonnull ReadWriteLock lock, @Nonnull Supplier<T> supplier) {
        return ThreadKit.inLock(lock.writeLock(), supplier);
    }
}

