/*
 * Decompiled with CFR 0.152.
 */
package com.logsentinel;

import com.logsentinel.BodySerializer;
import com.logsentinel.util.EncryptUtil;

public class EncryptingBodySerializer
implements BodySerializer {
    private byte[] encryptionKey;
    private BodySerializer originalSerializer;

    public EncryptingBodySerializer(byte[] encryptionKey, BodySerializer originalSerializer) {
        this.encryptionKey = encryptionKey;
        this.originalSerializer = originalSerializer;
    }

    @Override
    public String serialize(Object object) {
        String content = this.originalSerializer.serialize(object);
        return this.encryptConent(content, this.encryptionKey);
    }

    private String encryptConent(String content, byte[] encryptionKey) {
        try {
            return EncryptUtil.base64Encode(EncryptUtil.encrypt(content, encryptionKey, true));
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to perform symmetric encryption", ex);
        }
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }
}

