/*
 * Decompiled with CFR 0.152.
 */
package com.logsentinel;

import com.logsentinel.ApiClient;
import com.logsentinel.BodySerializer;
import com.logsentinel.BodySigner;
import com.logsentinel.EncryptingBodySerializer;
import com.logsentinel.EncryptingKeywordExtractor;
import com.logsentinel.JsonBodySerializer;
import com.logsentinel.LogSentinelClient;
import com.logsentinel.LuceneEncryptingKeywordExtractor;
import com.logsentinel.api.AlertsApi;
import com.logsentinel.api.ApplicationsApi;
import com.logsentinel.api.GdprLoggingApi;
import com.logsentinel.api.GdprRegisterApi;
import com.logsentinel.api.HashApi;
import com.logsentinel.api.LogHealthcareApi;
import com.logsentinel.api.LogSpecialApi;
import com.logsentinel.api.LoggingApi;
import com.logsentinel.api.OrganizationUsersApi;
import com.logsentinel.api.PartnersApi;
import com.logsentinel.api.SavedSearchesApi;
import com.logsentinel.api.SearchApi;
import com.logsentinel.api.VerificationApi;
import java.security.PrivateKey;

public class LogSentinelClientBuilder {
    private String applicationId;
    private String organizationId;
    private String secret;
    private byte[] encryptionKey;
    private PrivateKey signingKey;
    private BodySerializer bodySerializer;
    private String basePath;
    private EncryptingKeywordExtractor encryptingKeywordExtractor;
    private boolean async;
    private boolean trustAllCertificates;

    public static LogSentinelClientBuilder create(String applicationId, String organizationId, String secret) {
        LogSentinelClientBuilder builder = new LogSentinelClientBuilder();
        return builder.setApplicationId(applicationId).setOrganizationId(organizationId).setSecret(secret);
    }

    public LogSentinelClient build() {
        BodySerializer serializer;
        ApiClient apiClient = new ApiClient(this.trustAllCertificates);
        if (this.basePath != null) {
            apiClient.setBasePath(this.basePath);
        }
        apiClient.setUsername(this.organizationId.trim());
        apiClient.setPassword(this.secret.trim());
        apiClient.setAsync(this.async);
        if (this.applicationId != null) {
            apiClient.addDefaultHeader("Application-Id", this.applicationId.trim());
        }
        BodySerializer bodySerializer = serializer = this.bodySerializer != null ? this.bodySerializer : new JsonBodySerializer(apiClient.getJSON());
        if (this.encryptionKey != null) {
            serializer = new EncryptingBodySerializer(this.encryptionKey, serializer);
        }
        BodySigner signer = null;
        if (this.signingKey != null) {
            signer = new BodySigner(this.signingKey);
        }
        LoggingApi auditLogApi = new LoggingApi(apiClient, serializer, signer, this.encryptingKeywordExtractor);
        HashApi hashApi = new HashApi(apiClient, serializer, signer, this.encryptingKeywordExtractor);
        OrganizationUsersApi userApi = new OrganizationUsersApi(apiClient);
        ApplicationsApi applicationApi = new ApplicationsApi(apiClient);
        SearchApi searchApi = new SearchApi(apiClient);
        VerificationApi verificationApi = new VerificationApi(apiClient);
        GdprRegisterApi registerApi = new GdprRegisterApi(apiClient);
        GdprLoggingApi gdprLoggingApi = new GdprLoggingApi(apiClient);
        AlertsApi alertsApi = new AlertsApi(apiClient);
        LogHealthcareApi healthcareApi = new LogHealthcareApi(apiClient);
        LogSpecialApi logSpecialApi = new LogSpecialApi(apiClient);
        PartnersApi partnersApi = new PartnersApi(apiClient);
        SavedSearchesApi savedSearchApi = new SavedSearchesApi(apiClient);
        LogSentinelClient client = new LogSentinelClient(auditLogApi, hashApi, userApi, applicationApi, searchApi, verificationApi, healthcareApi, gdprLoggingApi, registerApi, alertsApi, logSpecialApi, partnersApi, userApi, savedSearchApi);
        return client;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public LogSentinelClientBuilder setApplicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public LogSentinelClientBuilder setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    public String getSecret() {
        return this.secret;
    }

    public LogSentinelClientBuilder setSecret(String secret) {
        this.secret = secret;
        return this;
    }

    public byte[] getEncryptionKey() {
        return this.encryptionKey;
    }

    public LogSentinelClientBuilder setEncryptionKey(byte[] keyBytes) {
        this.validateEncryptionKeyBytesLength(keyBytes);
        this.encryptionKey = keyBytes;
        this.encryptingKeywordExtractor = new LuceneEncryptingKeywordExtractor(this.encryptionKey);
        return this;
    }

    public BodySerializer getBodySerializer() {
        return this.bodySerializer;
    }

    public LogSentinelClientBuilder setBodySerializer(BodySerializer bodySerializer) {
        this.bodySerializer = bodySerializer;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public LogSentinelClientBuilder setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public LogSentinelClientBuilder setSigningKey(PrivateKey signingKey) {
        this.signingKey = signingKey;
        return this;
    }

    private void validateEncryptionKeyPhraseLength(String keyPhrase) {
        if (keyPhrase.length() != 8 && keyPhrase.length() != 16) {
            throw new IllegalArgumentException("Illegal key phrase length: " + keyPhrase.length() + ". Must be 8 or 16");
        }
    }

    private void validateEncryptionKeyBytesLength(byte[] keyBytes) {
        if (keyBytes.length != 16 && keyBytes.length != 32) {
            throw new IllegalArgumentException("Illegal key length: " + keyBytes.length + ". Must be 16 or 32");
        }
    }

    public LogSentinelClientBuilder setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public LogSentinelClientBuilder setTrustAllCertificates(boolean trustAllCertificates) {
        this.trustAllCertificates = trustAllCertificates;
        return this;
    }
}

