/*
 * Decompiled with CFR 0.152.
 */
package com.logsentinel;

import com.logsentinel.EncryptingKeywordExtractor;
import com.logsentinel.util.EncryptUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class LuceneEncryptingKeywordExtractor
implements EncryptingKeywordExtractor {
    private static Analyzer analyzer = new StandardAnalyzer();
    private byte[] encryptionKey;

    public LuceneEncryptingKeywordExtractor(byte[] encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    @Override
    public List<String> extract(String text) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            TokenStream stream = analyzer.tokenStream(null, (Reader)new StringReader(text));
            stream.reset();
            while (stream.incrementToken()) {
                result.add(this.encrypt(((CharTermAttribute)stream.getAttribute(CharTermAttribute.class)).toString()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private String encrypt(String keyWord) {
        if (this.encryptionKey == null) {
            return keyWord;
        }
        try {
            byte[] encrypted = EncryptUtil.encrypt(keyWord, this.encryptionKey, false);
            byte[] hashed = EncryptUtil.hash(encrypted);
            return EncryptUtil.base64Encode(hashed);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to perform keyword encryption", e);
        }
    }
}

