/*
 * Decompiled with CFR 0.152.
 */
package com.logsentinel.api;

import com.logsentinel.ApiClient;
import com.logsentinel.ApiException;
import com.logsentinel.ApiResponse;
import com.logsentinel.Configuration;
import com.logsentinel.Pair;
import com.logsentinel.model.Consent;
import com.logsentinel.model.GDPRRequest;
import com.logsentinel.model.LogResponse;
import com.logsentinel.model.Result;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class GdprLoggingApi {
    private ApiClient apiClient;

    public GdprLoggingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GdprLoggingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public LogResponse logConsent(Consent consent, String signature, List<String> encryptedKeywords) throws ApiException {
        return this.logConsentWithHttpInfo(consent, signature, encryptedKeywords).getData();
    }

    public ApiResponse<LogResponse> logConsentWithHttpInfo(Consent consent, String signature, List<String> encryptedKeywords) throws ApiException {
        Consent localVarPostBody = consent;
        if (consent == null) {
            throw new ApiException(400, "Missing the required parameter 'consent' when calling logConsent");
        }
        String localVarPath = "/api/log-gdpr/consent";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "encryptedKeywords", encryptedKeywords));
        if (signature != null) {
            localVarHeaderParams.put("Signature", this.apiClient.parameterToString(signature));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<LogResponse> localVarReturnType = new GenericType<LogResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LogResponse logGdprRequest(GDPRRequest gdprRequest, String requestType, String signature, List<String> encryptedKeywords) throws ApiException {
        return this.logGdprRequestWithHttpInfo(gdprRequest, requestType, signature, encryptedKeywords).getData();
    }

    public ApiResponse<LogResponse> logGdprRequestWithHttpInfo(GDPRRequest gdprRequest, String requestType, String signature, List<String> encryptedKeywords) throws ApiException {
        GDPRRequest localVarPostBody = gdprRequest;
        if (gdprRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'gdprRequest' when calling logGdprRequest");
        }
        if (requestType == null) {
            throw new ApiException(400, "Missing the required parameter 'requestType' when calling logGdprRequest");
        }
        String localVarPath = "/api/log-gdpr/request/{requestType}".replaceAll("\\{requestType\\}", this.apiClient.escapeString(requestType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "encryptedKeywords", encryptedKeywords));
        if (signature != null) {
            localVarHeaderParams.put("Signature", this.apiClient.parameterToString(signature));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<LogResponse> localVarReturnType = new GenericType<LogResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LogResponse logRequestResults(String requestType, Result result, String signature, List<String> encryptedKeywords) throws ApiException {
        return this.logRequestResultsWithHttpInfo(requestType, result, signature, encryptedKeywords).getData();
    }

    public ApiResponse<LogResponse> logRequestResultsWithHttpInfo(String requestType, Result result, String signature, List<String> encryptedKeywords) throws ApiException {
        Result localVarPostBody = result;
        if (requestType == null) {
            throw new ApiException(400, "Missing the required parameter 'requestType' when calling logRequestResults");
        }
        if (result == null) {
            throw new ApiException(400, "Missing the required parameter 'result' when calling logRequestResults");
        }
        String localVarPath = "/api/log-gdpr/request-result/{requestType}".replaceAll("\\{requestType\\}", this.apiClient.escapeString(requestType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "encryptedKeywords", encryptedKeywords));
        if (signature != null) {
            localVarHeaderParams.put("Signature", this.apiClient.parameterToString(signature));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<LogResponse> localVarReturnType = new GenericType<LogResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

