/*
 * Decompiled with CFR 0.152.
 */
package com.logsentinel.api;

import com.logsentinel.ApiClient;
import com.logsentinel.ApiException;
import com.logsentinel.ApiResponse;
import com.logsentinel.BodySerializer;
import com.logsentinel.BodySigner;
import com.logsentinel.Configuration;
import com.logsentinel.EncryptingKeywordExtractor;
import com.logsentinel.Pair;
import com.logsentinel.client.BodyAndKeywords;
import com.logsentinel.model.ActionData;
import com.logsentinel.model.ActorData;
import com.logsentinel.util.EncryptUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.core.GenericType;

public class HashApi {
    private ApiClient apiClient;
    private BodySerializer bodySerializer;
    private BodySigner bodySigner;
    private EncryptingKeywordExtractor encryptingKeywordExtractor;

    public HashApi() {
        this(Configuration.getDefaultApiClient(), null, null, null);
    }

    public HashApi(ApiClient apiClient, BodySerializer bodySerializer, BodySigner bodySigner, EncryptingKeywordExtractor encryptingKeywordExtractor) {
        this.apiClient = apiClient;
        this.bodySerializer = bodySerializer;
        this.bodySigner = bodySigner;
        this.encryptingKeywordExtractor = encryptingKeywordExtractor;
    }

    public HashApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public String getHash(UUID applicationId, UUID entryId) throws ApiException {
        return this.getHashWithHttpInfo(applicationId, entryId).getData();
    }

    public ApiResponse<String> getHashWithHttpInfo(UUID applicationId, UUID entryId) throws ApiException {
        Object localVarPostBody = null;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getHash");
        }
        if (entryId == null) {
            throw new ApiException(400, "Missing the required parameter 'entryId' when calling getHash");
        }
        String localVarPath = "/api/getStandaloneHash";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "entryId", entryId));
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String getHashableContent(UUID applicationId, String action, String actorId, String auditLogEntryType, String signature, String actorDepartment, String actorDisplayName, List<String> actorRoles, String details, String logLevel, Long originalEventTimestamp, Map<String, String> additionalParams) throws ApiException {
        return this.getHashableContentWithHttpInfo(applicationId, action, actorId, auditLogEntryType, signature, actorDepartment, actorDisplayName, actorRoles, details, logLevel, originalEventTimestamp, additionalParams).getData();
    }

    public ApiResponse<String> getHashableContentWithHttpInfo(UUID applicationId, String action, String actorId, String auditLogEntryType, String signature, String actorDepartment, String actorDisplayName, List<String> actorRoles, String details, String logLevel, Long originalEventTimestamp, Map<String, String> additionalParams) throws ApiException {
        String localVarPostBody = details;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getHashableContent");
        }
        if (action == null) {
            throw new ApiException(400, "Missing the required parameter 'action' when calling getHashableContent");
        }
        if (actorId == null) {
            throw new ApiException(400, "Missing the required parameter 'actorId' when calling getHashableContent");
        }
        String localVarPath = "/api/getHashableContent/{actorId}/{action}".replaceAll("\\{action\\}", this.apiClient.escapeString(action.toString())).replaceAll("\\{actorId\\}", this.apiClient.escapeString(actorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "actorDepartment", actorDepartment));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "actorDisplayName", actorDisplayName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "actorRoles", actorRoles));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "logLevel", logLevel));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "originalEventTimestamp", originalEventTimestamp));
        if (additionalParams != null && !additionalParams.isEmpty()) {
            additionalParams.forEach((k, v) -> localVarQueryParams.add(new Pair((String)k, (String)v)));
        }
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        if (auditLogEntryType != null) {
            localVarHeaderParams.put("Audit-Log-Entry-Type", this.apiClient.parameterToString(auditLogEntryType));
        }
        if (signature != null) {
            localVarHeaderParams.put("Signature", this.apiClient.parameterToString(signature));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String getHashableContentForAuthAction(UUID applicationId, String actorId, String authAction, String signature, String signedLoginChallenge, String userPublicKey, String actorDepartment, String actorDisplayName, List<String> actorRoles, String details, Long originalEventTimestamp, Map<String, String> additionalParams) throws ApiException {
        return this.getHashableContentForAuthActionWithHttpInfo(applicationId, actorId, authAction, signature, signedLoginChallenge, userPublicKey, actorDepartment, actorDisplayName, actorRoles, details, originalEventTimestamp, additionalParams).getData();
    }

    public ApiResponse<String> getHashableContentForAuthActionWithHttpInfo(UUID applicationId, String actorId, String authAction, String signature, String signedLoginChallenge, String userPublicKey, String actorDepartment, String actorDisplayName, List<String> actorRoles, String details, Long originalEventTimestamp, Map<String, String> additionalParams) throws ApiException {
        String localVarPostBody = details;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getHashableContentForAuthAction");
        }
        if (actorId == null) {
            throw new ApiException(400, "Missing the required parameter 'actorId' when calling getHashableContentForAuthAction");
        }
        if (authAction == null) {
            throw new ApiException(400, "Missing the required parameter 'authAction' when calling getHashableContentForAuthAction");
        }
        String localVarPath = "/api/getHashableContent/{actorId}/auth/{authAction}".replaceAll("\\{actorId\\}", this.apiClient.escapeString(actorId.toString())).replaceAll("\\{authAction\\}", this.apiClient.escapeString(authAction.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "actorDepartment", actorDepartment));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "actorDisplayName", actorDisplayName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "actorRoles", actorRoles));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "originalEventTimestamp", originalEventTimestamp));
        if (additionalParams != null && !additionalParams.isEmpty()) {
            additionalParams.forEach((k, v) -> localVarQueryParams.add(new Pair((String)k, (String)v)));
        }
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        if (signature != null) {
            localVarHeaderParams.put("Signature", this.apiClient.parameterToString(signature));
        }
        if (signedLoginChallenge != null) {
            localVarHeaderParams.put("Signed-Login-Challenge", this.apiClient.parameterToString(signedLoginChallenge));
        }
        if (userPublicKey != null) {
            localVarHeaderParams.put("User-Public-Key", this.apiClient.parameterToString(userPublicKey));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String getHashableContentForStandardAction(UUID applicationId, String action, String actorId, String entityId, String entityType, String auditLogEntryType, String signature, String actorDepartment, String actorDisplayName, List<String> actorRoles, String details, String logLevel, Long originalEventTimestamp, Map<String, String> additionalParams) throws ApiException {
        return this.getHashableContentForStandardActionWithHttpInfo(applicationId, action, actorId, entityId, entityType, auditLogEntryType, signature, actorDepartment, actorDisplayName, actorRoles, details, logLevel, originalEventTimestamp, additionalParams).getData();
    }

    public ApiResponse<String> getHashableContentForStandardActionWithHttpInfo(UUID applicationId, String action, String actorId, String entityId, String entityType, String auditLogEntryType, String signature, String actorDepartment, String actorDisplayName, List<String> actorRoles, String details, String logLevel, Long originalEventTimestamp, Map<String, String> additionalParams) throws ApiException {
        String localVarPostBody = details;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getHashableContentForStandardAction");
        }
        if (action == null) {
            throw new ApiException(400, "Missing the required parameter 'action' when calling getHashableContentForStandardAction");
        }
        if (actorId == null) {
            throw new ApiException(400, "Missing the required parameter 'actorId' when calling getHashableContentForStandardAction");
        }
        if (entityId == null) {
            throw new ApiException(400, "Missing the required parameter 'entityId' when calling getHashableContentForStandardAction");
        }
        if (entityType == null) {
            throw new ApiException(400, "Missing the required parameter 'entityType' when calling getHashableContentForStandardAction");
        }
        String localVarPath = "/api/getHashableContent/{actorId}/{action}/{entityType}/{entityId}".replaceAll("\\{action\\}", this.apiClient.escapeString(action.toString())).replaceAll("\\{actorId\\}", this.apiClient.escapeString(actorId.toString())).replaceAll("\\{entityId\\}", this.apiClient.escapeString(entityId.toString())).replaceAll("\\{entityType\\}", this.apiClient.escapeString(entityType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "actorDepartment", actorDepartment));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "actorDisplayName", actorDisplayName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "actorRoles", actorRoles));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "logLevel", logLevel));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "originalEventTimestamp", originalEventTimestamp));
        if (additionalParams != null && !additionalParams.isEmpty()) {
            additionalParams.forEach((k, v) -> localVarQueryParams.add(new Pair((String)k, (String)v)));
        }
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        if (auditLogEntryType != null) {
            localVarHeaderParams.put("Audit-Log-Entry-Type", this.apiClient.parameterToString(auditLogEntryType));
        }
        if (signature != null) {
            localVarHeaderParams.put("Signature", this.apiClient.parameterToString(signature));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String getHashableContentSimple(UUID applicationId, String auditLogEntryType, String signature, String details, String logLevel, Long originalEventTimestamp, Map<String, String> additionalParams) throws ApiException {
        return this.getHashableContentSimpleWithHttpInfo(applicationId, auditLogEntryType, signature, details, logLevel, originalEventTimestamp, additionalParams).getData();
    }

    public ApiResponse<String> getHashableContentSimpleWithHttpInfo(UUID applicationId, String auditLogEntryType, String signature, String details, String logLevel, Long originalEventTimestamp, Map<String, String> additionalParams) throws ApiException {
        String localVarPostBody = details;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getHashableContentSimple");
        }
        String localVarPath = "/api/getHashableContent";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "logLevel", logLevel));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "originalEventTimestamp", originalEventTimestamp));
        if (additionalParams != null && !additionalParams.isEmpty()) {
            additionalParams.forEach((k, v) -> localVarQueryParams.add(new Pair((String)k, (String)v)));
        }
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        if (auditLogEntryType != null) {
            localVarHeaderParams.put("Audit-Log-Entry-Type", this.apiClient.parameterToString(auditLogEntryType));
        }
        if (signature != null) {
            localVarHeaderParams.put("Signature", this.apiClient.parameterToString(signature));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public <T> String getHashableContent(ActorData actorData, ActionData<T> actionData, UUID applicationId) {
        BodyAndKeywords bodyAndKeywords = this.preProcessBody(actionData);
        String signature = null;
        if (this.bodySigner != null) {
            signature = this.bodySigner.computeSignature(bodyAndKeywords.getBody());
        }
        String entryType = ActionData.EntryTypeEnum.BUSINESS_LOGIC_ENTRY.getValue();
        if (actionData.getEntryType() != null) {
            entryType = actionData.getEntryType().getValue();
        }
        return this.getHashableContent(applicationId, actionData.getAction(), actorData.getActorId(), entryType, signature, actorData.getDepartment(), actorData.getActorDisplayName(), actorData.getActorRoles(), bodyAndKeywords.getBody(), null, actionData.getOriginalEventTimestamp(), actionData.getAdditionalParams());
    }

    private <T> BodyAndKeywords preProcessBody(ActionData<T> actionData) {
        String serialized = null;
        List<String> keywords = null;
        if (actionData.getDetails() != null) {
            serialized = this.bodySerializer.serialize(actionData.getDetails());
            if (this.encryptingKeywordExtractor != null) {
                keywords = this.encryptingKeywordExtractor.extract(actionData.getDetails().toString());
            }
        } else {
            serialized = this.bodySerializer.serialize(actionData.getDiffDetails());
            if (this.encryptingKeywordExtractor != null) {
                keywords = this.encryptingKeywordExtractor.extract(actionData.getDiffDetails().toString());
            }
        }
        if (actionData.getEncryptionKey() != null) {
            try {
                serialized = EncryptUtil.base64Encode(EncryptUtil.encrypt(serialized, actionData.getEncryptionKey(), true));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to perform symmetric encryption", e);
            }
        }
        return new BodyAndKeywords(serialized, keywords);
    }
}

