/*
 * Decompiled with CFR 0.152.
 */
package com.logsentinel.api;

import com.logsentinel.ApiClient;
import com.logsentinel.ApiException;
import com.logsentinel.ApiResponse;
import com.logsentinel.Configuration;
import com.logsentinel.Pair;
import com.logsentinel.model.LogResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class LogHealthcareApi {
    private ApiClient apiClient;

    public LogHealthcareApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LogHealthcareApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public LogResponse logDicomEvent(String applicationId, String dicomAuditEvent) throws ApiException {
        return this.logDicomEventWithHttpInfo(applicationId, dicomAuditEvent).getData();
    }

    public ApiResponse<LogResponse> logDicomEventWithHttpInfo(String applicationId, String dicomAuditEvent) throws ApiException {
        String localVarPostBody = dicomAuditEvent;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling logDicomEvent");
        }
        if (dicomAuditEvent == null) {
            throw new ApiException(400, "Missing the required parameter 'dicomAuditEvent' when calling logDicomEvent");
        }
        String localVarPath = "/api/dicom/log";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<LogResponse> localVarReturnType = new GenericType<LogResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LogResponse logFhirEvent(String applicationId, String fhirAuditEvent) throws ApiException {
        return this.logFhirEventWithHttpInfo(applicationId, fhirAuditEvent).getData();
    }

    public ApiResponse<LogResponse> logFhirEventWithHttpInfo(String applicationId, String fhirAuditEvent) throws ApiException {
        String localVarPostBody = fhirAuditEvent;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling logFhirEvent");
        }
        if (fhirAuditEvent == null) {
            throw new ApiException(400, "Missing the required parameter 'fhirAuditEvent' when calling logFhirEvent");
        }
        String localVarPath = "/api/fhir/log";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<LogResponse> localVarReturnType = new GenericType<LogResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LogResponse logIheEvent(String applicationId, String iheAuditEvent) throws ApiException {
        return this.logIheEventWithHttpInfo(applicationId, iheAuditEvent).getData();
    }

    public ApiResponse<LogResponse> logIheEventWithHttpInfo(String applicationId, String iheAuditEvent) throws ApiException {
        String localVarPostBody = iheAuditEvent;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling logIheEvent");
        }
        if (iheAuditEvent == null) {
            throw new ApiException(400, "Missing the required parameter 'iheAuditEvent' when calling logIheEvent");
        }
        String localVarPath = "/api/ihe/log";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<LogResponse> localVarReturnType = new GenericType<LogResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

