/*
 * Decompiled with CFR 0.152.
 */
package com.logsentinel.api;

import com.logsentinel.ApiClient;
import com.logsentinel.ApiException;
import com.logsentinel.ApiResponse;
import com.logsentinel.BodySerializer;
import com.logsentinel.BodySigner;
import com.logsentinel.Configuration;
import com.logsentinel.EncryptingKeywordExtractor;
import com.logsentinel.Pair;
import com.logsentinel.client.BodyAndKeywords;
import com.logsentinel.model.ActionData;
import com.logsentinel.model.ActorData;
import com.logsentinel.model.AuditLogEntry;
import com.logsentinel.model.BatchLogRequestEntry;
import com.logsentinel.model.LogResponse;
import com.logsentinel.util.EncryptUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.core.GenericType;

public class LoggingApi {
    private ApiClient apiClient;
    private BodySerializer bodySerializer;
    private BodySigner bodySigner;
    private EncryptingKeywordExtractor encryptingKeywordExtractor;

    public LoggingApi() {
        this(Configuration.getDefaultApiClient(), null, null, null);
    }

    public LoggingApi(ApiClient apiClient, BodySerializer bodySerializer, BodySigner bodySigner, EncryptingKeywordExtractor encryptingKeywordExtractor) {
        this.apiClient = apiClient;
        this.bodySerializer = bodySerializer;
        this.bodySigner = bodySigner;
        this.encryptingKeywordExtractor = encryptingKeywordExtractor;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AuditLogEntry getEntryById(UUID applicationId, String entryId) throws ApiException {
        return this.getEntryByIdWithHttpInfo(applicationId, entryId).getData();
    }

    public ApiResponse<AuditLogEntry> getEntryByIdWithHttpInfo(UUID applicationId, String entryId) throws ApiException {
        Object localVarPostBody = null;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getEntryById");
        }
        if (entryId == null) {
            throw new ApiException(400, "Missing the required parameter 'entryId' when calling getEntryById");
        }
        String localVarPath = "/api/getEntryById";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "entryId", entryId));
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<AuditLogEntry> localVarReturnType = new GenericType<AuditLogEntry>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LogResponse getHashByEntryId(UUID applicationId, String entryId) throws ApiException {
        return this.getHashByEntryIdWithHttpInfo(applicationId, entryId).getData();
    }

    public ApiResponse<LogResponse> getHashByEntryIdWithHttpInfo(UUID applicationId, String entryId) throws ApiException {
        Object localVarPostBody = null;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getHashByEntryId");
        }
        if (entryId == null) {
            throw new ApiException(400, "Missing the required parameter 'entryId' when calling getHashByEntryId");
        }
        String localVarPath = "/api/getHashByEntryId";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "entryId", entryId));
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<LogResponse> localVarReturnType = new GenericType<LogResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LogResponse log(UUID applicationId, String action, String actorId, String auditLogEntryType, String signature, String actorDepartment, String actorDisplayName, List<String> actorRoles, Boolean binaryContent, byte[] details, List<String> directExternalPush, List<String> encryptedKeywords, String gdprCorrelationKey, String logLevel, Long originalEventTimestamp, String process, Map<String, String> additionalParams) throws ApiException {
        return this.logWithHttpInfo(applicationId, action, actorId, auditLogEntryType, signature, actorDepartment, actorDisplayName, actorRoles, binaryContent, details, directExternalPush, encryptedKeywords, gdprCorrelationKey, logLevel, originalEventTimestamp, process, additionalParams).getData();
    }

    public ApiResponse<LogResponse> logWithHttpInfo(UUID applicationId, String action, String actorId, String auditLogEntryType, String signature, String actorDepartment, String actorDisplayName, List<String> actorRoles, Boolean binaryContent, byte[] details, List<String> directExternalPush, List<String> encryptedKeywords, String gdprCorrelationKey, String logLevel, Long originalEventTimestamp, String process, Map<String, String> additionalParams) throws ApiException {
        byte[] localVarPostBody = details;
        if (action == null) {
            throw new ApiException(400, "Missing the required parameter 'action' when calling log");
        }
        if (actorId == null) {
            throw new ApiException(400, "Missing the required parameter 'actorId' when calling log");
        }
        String localVarPath = "/api/log/{actorId}/{action}".replaceAll("\\{action\\}", this.apiClient.escapeString(action.toString())).replaceAll("\\{actorId\\}", this.apiClient.escapeString(actorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "actorDepartment", actorDepartment));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "actorDisplayName", actorDisplayName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "actorRoles", actorRoles));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "binaryContent", binaryContent));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "directExternalPush", directExternalPush));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "encryptedKeywords", encryptedKeywords));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "gdprCorrelationKey", gdprCorrelationKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "logLevel", logLevel));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "originalEventTimestamp", originalEventTimestamp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "process", process));
        if (additionalParams != null && !additionalParams.isEmpty()) {
            additionalParams.forEach((k, v) -> localVarQueryParams.add(new Pair((String)k, (String)v)));
        }
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        if (auditLogEntryType != null) {
            localVarHeaderParams.put("Audit-Log-Entry-Type", this.apiClient.parameterToString(auditLogEntryType));
        }
        if (signature != null) {
            localVarHeaderParams.put("Signature", this.apiClient.parameterToString(signature));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<LogResponse> localVarReturnType = new GenericType<LogResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LogResponse logAuthAction(UUID applicationId, String actorId, String authAction, String signature, String signedLoginChallenge, String userPublicKey, String actorDepartment, String actorDisplayName, List<String> actorRoles, Boolean binaryContent, byte[] details, List<String> directExternalPush, List<String> encryptedKeywords, String gdprCorrelationKey, Long originalEventTimestamp, String process, Map<String, String> additionalParams) throws ApiException {
        return this.logAuthActionWithHttpInfo(applicationId, actorId, authAction, signature, signedLoginChallenge, userPublicKey, actorDepartment, actorDisplayName, actorRoles, binaryContent, details, directExternalPush, encryptedKeywords, gdprCorrelationKey, originalEventTimestamp, process, additionalParams).getData();
    }

    public ApiResponse<LogResponse> logAuthActionWithHttpInfo(UUID applicationId, String actorId, String authAction, String signature, String signedLoginChallenge, String userPublicKey, String actorDepartment, String actorDisplayName, List<String> actorRoles, Boolean binaryContent, byte[] details, List<String> directExternalPush, List<String> encryptedKeywords, String gdprCorrelationKey, Long originalEventTimestamp, String process, Map<String, String> additionalParams) throws ApiException {
        byte[] localVarPostBody = details;
        if (actorId == null) {
            throw new ApiException(400, "Missing the required parameter 'actorId' when calling logAuthAction");
        }
        if (authAction == null) {
            throw new ApiException(400, "Missing the required parameter 'authAction' when calling logAuthAction");
        }
        String localVarPath = "/api/log/{actorId}/auth/{authAction}".replaceAll("\\{actorId\\}", this.apiClient.escapeString(actorId.toString())).replaceAll("\\{authAction\\}", this.apiClient.escapeString(authAction.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "actorDepartment", actorDepartment));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "actorDisplayName", actorDisplayName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "actorRoles", actorRoles));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "binaryContent", binaryContent));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "directExternalPush", directExternalPush));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "encryptedKeywords", encryptedKeywords));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "gdprCorrelationKey", gdprCorrelationKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "originalEventTimestamp", originalEventTimestamp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "process", process));
        if (additionalParams != null && !additionalParams.isEmpty()) {
            additionalParams.forEach((k, v) -> localVarQueryParams.add(new Pair((String)k, (String)v)));
        }
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        if (signature != null) {
            localVarHeaderParams.put("Signature", this.apiClient.parameterToString(signature));
        }
        if (signedLoginChallenge != null) {
            localVarHeaderParams.put("Signed-Login-Challenge", this.apiClient.parameterToString(signedLoginChallenge));
        }
        if (userPublicKey != null) {
            localVarHeaderParams.put("User-Public-Key", this.apiClient.parameterToString(userPublicKey));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<LogResponse> localVarReturnType = new GenericType<LogResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public <T> LogResponse logBatch(UUID applicationId, List<BatchLogRequestEntry<T>> requestData) throws ApiException {
        return this.logBatchWithHttpInfo(applicationId, requestData).getData();
    }

    public <T> LogResponse logBatch(List<BatchLogRequestEntry<T>> requestData) throws ApiException {
        return this.logBatchWithHttpInfo(null, requestData).getData();
    }

    public <T> ApiResponse<LogResponse> logBatchWithHttpInfo(UUID applicationId, List<BatchLogRequestEntry<T>> requestData) throws ApiException {
        List<BatchLogRequestEntry<BatchLogRequestEntry>> localVarPostBody = requestData;
        if (requestData == null) {
            throw new ApiException(400, "Missing the required parameter 'requestData' when calling logBatch");
        }
        String localVarPath = "/api/log/batch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        requestData.forEach(e -> {
            if (e.getAdditionalParams() == null) {
                e.setAdditionalParams(new HashMap<String, String>());
            }
            if (e.getActionData() != null && e.getActionData().getAdditionalParams() != null) {
                e.getActionData().getAdditionalParams().forEach((k, v) -> e.getAdditionalParams().put((String)k, (String)v));
            }
        });
        GenericType<LogResponse> localVarReturnType = new GenericType<LogResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LogResponse logDocument(UUID applicationId, String action, String actorId, byte[] details, String documentId, String signature, String actorDepartment, String actorDisplayName, List<String> actorRoles, Boolean binaryContent, List<String> directExternalPush, String documentName, String documentType, List<String> encryptedKeywords, String gdprCorrelationKey, Long originalEventTimestamp, String process, Map<String, String> additionalParams) throws ApiException {
        return this.logDocumentWithHttpInfo(applicationId, action, actorId, details, documentId, signature, actorDepartment, actorDisplayName, actorRoles, binaryContent, directExternalPush, documentName, documentType, encryptedKeywords, gdprCorrelationKey, originalEventTimestamp, process, additionalParams).getData();
    }

    public ApiResponse<LogResponse> logDocumentWithHttpInfo(UUID applicationId, String action, String actorId, byte[] details, String documentId, String signature, String actorDepartment, String actorDisplayName, List<String> actorRoles, Boolean binaryContent, List<String> directExternalPush, String documentName, String documentType, List<String> encryptedKeywords, String gdprCorrelationKey, Long originalEventTimestamp, String process, Map<String, String> additionalParams) throws ApiException {
        byte[] localVarPostBody = details;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling logDocument");
        }
        if (action == null) {
            throw new ApiException(400, "Missing the required parameter 'action' when calling logDocument");
        }
        if (actorId == null) {
            throw new ApiException(400, "Missing the required parameter 'actorId' when calling logDocument");
        }
        if (details == null) {
            throw new ApiException(400, "Missing the required parameter 'details' when calling logDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling logDocument");
        }
        String localVarPath = "/api/log/document/{actorId}/{action}/{documentId}".replaceAll("\\{action\\}", this.apiClient.escapeString(action.toString())).replaceAll("\\{actorId\\}", this.apiClient.escapeString(actorId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "actorDepartment", actorDepartment));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "actorDisplayName", actorDisplayName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "actorRoles", actorRoles));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "binaryContent", binaryContent));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "directExternalPush", directExternalPush));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "documentName", documentName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "documentType", documentType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "encryptedKeywords", encryptedKeywords));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "gdprCorrelationKey", gdprCorrelationKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "originalEventTimestamp", originalEventTimestamp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "process", process));
        if (additionalParams != null && !additionalParams.isEmpty()) {
            additionalParams.forEach((k, v) -> localVarQueryParams.add(new Pair((String)k, (String)v)));
        }
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        if (signature != null) {
            localVarHeaderParams.put("Signature", this.apiClient.parameterToString(signature));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<LogResponse> localVarReturnType = new GenericType<LogResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LogResponse logFull(UUID applicationId, String action, String actorId, String entityId, String entityType, String auditLogEntryType, String signature, String actorDepartment, String actorDisplayName, List<String> actorRoles, Boolean binaryContent, byte[] details, List<String> directExternalPush, List<String> encryptedKeywords, String gdprCorrelationKey, String logLevel, Long originalEventTimestamp, String process, Map<String, String> additionalParams) throws ApiException {
        return this.logFullWithHttpInfo(applicationId, action, actorId, entityId, entityType, auditLogEntryType, signature, actorDepartment, actorDisplayName, actorRoles, binaryContent, details, directExternalPush, encryptedKeywords, gdprCorrelationKey, logLevel, originalEventTimestamp, process, additionalParams).getData();
    }

    public ApiResponse<LogResponse> logFullWithHttpInfo(UUID applicationId, String action, String actorId, String entityId, String entityType, String auditLogEntryType, String signature, String actorDepartment, String actorDisplayName, List<String> actorRoles, Boolean binaryContent, byte[] details, List<String> directExternalPush, List<String> encryptedKeywords, String gdprCorrelationKey, String logLevel, Long originalEventTimestamp, String process, Map<String, String> additionalParams) throws ApiException {
        byte[] localVarPostBody = details;
        if (action == null) {
            throw new ApiException(400, "Missing the required parameter 'action' when calling logFull");
        }
        if (actorId == null) {
            throw new ApiException(400, "Missing the required parameter 'actorId' when calling logFull");
        }
        if (entityId == null) {
            throw new ApiException(400, "Missing the required parameter 'entityId' when calling logFull");
        }
        if (entityType == null) {
            throw new ApiException(400, "Missing the required parameter 'entityType' when calling logFull");
        }
        String localVarPath = "/api/log/{actorId}/{action}/{entityType}/{entityId}".replaceAll("\\{action\\}", this.apiClient.escapeString(action.toString())).replaceAll("\\{actorId\\}", this.apiClient.escapeString(actorId.toString())).replaceAll("\\{entityId\\}", this.apiClient.escapeString(entityId.toString())).replaceAll("\\{entityType\\}", this.apiClient.escapeString(entityType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "actorDepartment", actorDepartment));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "actorDisplayName", actorDisplayName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "actorRoles", actorRoles));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "binaryContent", binaryContent));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "directExternalPush", directExternalPush));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "encryptedKeywords", encryptedKeywords));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "gdprCorrelationKey", gdprCorrelationKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "logLevel", logLevel));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "originalEventTimestamp", originalEventTimestamp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "process", process));
        if (additionalParams != null && !additionalParams.isEmpty()) {
            additionalParams.forEach((k, v) -> localVarQueryParams.add(new Pair((String)k, (String)v)));
        }
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        if (auditLogEntryType != null) {
            localVarHeaderParams.put("Audit-Log-Entry-Type", this.apiClient.parameterToString(auditLogEntryType));
        }
        if (signature != null) {
            localVarHeaderParams.put("Signature", this.apiClient.parameterToString(signature));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<LogResponse> localVarReturnType = new GenericType<LogResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LogResponse logSimple(UUID applicationId, String auditLogEntryType, String signature, Boolean binaryContent, byte[] details, List<String> directExternalPush, List<String> encryptedKeywords, String logLevel, Long originalEventTimestamp, Map<String, String> additionalParams) throws ApiException {
        return this.logSimpleWithHttpInfo(applicationId, auditLogEntryType, signature, binaryContent, details, directExternalPush, encryptedKeywords, logLevel, originalEventTimestamp, additionalParams).getData();
    }

    public ApiResponse<LogResponse> logSimpleWithHttpInfo(UUID applicationId, String auditLogEntryType, String signature, Boolean binaryContent, byte[] details, List<String> directExternalPush, List<String> encryptedKeywords, String logLevel, Long originalEventTimestamp, Map<String, String> additionalParams) throws ApiException {
        byte[] localVarPostBody = details;
        String localVarPath = "/api/log/simple";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "binaryContent", binaryContent));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "directExternalPush", directExternalPush));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "encryptedKeywords", encryptedKeywords));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "logLevel", logLevel));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "originalEventTimestamp", originalEventTimestamp));
        if (additionalParams != null && !additionalParams.isEmpty()) {
            additionalParams.forEach((k, v) -> localVarQueryParams.add(new Pair((String)k, (String)v)));
        }
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        if (auditLogEntryType != null) {
            localVarHeaderParams.put("Audit-Log-Entry-Type", this.apiClient.parameterToString(auditLogEntryType));
        }
        if (signature != null) {
            localVarHeaderParams.put("Signature", this.apiClient.parameterToString(signature));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<LogResponse> localVarReturnType = new GenericType<LogResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public <T> LogResponse log(ActorData actorData, ActionData<T> actionData) {
        return this.log(actorData, actionData, null);
    }

    public <T> LogResponse log(ActorData actorData, ActionData<T> actionData, UUID applicationId) {
        BodyAndKeywords bodyAndKeywords = this.preProcessBody(actionData);
        String signature = null;
        if (this.bodySigner != null) {
            signature = this.bodySigner.computeSignature(bodyAndKeywords.getBody());
        }
        byte[] body = null;
        if (bodyAndKeywords.getBody() != null) {
            body = bodyAndKeywords.getBody().getBytes(StandardCharsets.UTF_8);
        }
        String entryType = ActionData.EntryTypeEnum.BUSINESS_LOGIC_ENTRY.getValue();
        if (actionData.getEntryType() != null) {
            entryType = actionData.getEntryType().getValue();
        }
        if (actionData.getEntityType() != null && actionData.getEntityId() != null) {
            return this.logFull(applicationId, actionData.getAction(), actorData.getActorId(), actionData.getEntityId(), actionData.getEntityType(), entryType, signature, actorData.getDepartment(), actorData.getActorDisplayName(), actorData.getActorRoles(), actionData.isBinaryContent(), body, null, bodyAndKeywords.getKeywords(), null, null, actionData.getOriginalEventTimestamp(), null, actionData.getAdditionalParams());
        }
        if (actionData.getAction() != null && actorData.getActorId() != null) {
            return this.log(applicationId, actionData.getAction(), actorData.getActorId(), entryType, signature, actorData.getDepartment(), actorData.getActorDisplayName(), actorData.getActorRoles(), actionData.isBinaryContent(), body, null, bodyAndKeywords.getKeywords(), null, null, actionData.getOriginalEventTimestamp(), null, actionData.getAdditionalParams());
        }
        return this.logSimple(applicationId, entryType, signature, actionData.isBinaryContent(), body, null, bodyAndKeywords.getKeywords(), null, actionData.getOriginalEventTimestamp(), actionData.getAdditionalParams());
    }

    private <T> BodyAndKeywords preProcessBody(ActionData<T> actionData) {
        String serialized = null;
        List<String> keywords = null;
        if (actionData.getDetails() != null) {
            serialized = this.bodySerializer.serialize(actionData.getDetails());
            if (this.encryptingKeywordExtractor != null) {
                keywords = this.encryptingKeywordExtractor.extract(actionData.getDetails().toString());
            }
        } else {
            serialized = this.bodySerializer.serialize(actionData.getDiffDetails());
            if (this.encryptingKeywordExtractor != null) {
                keywords = this.encryptingKeywordExtractor.extract(actionData.getDiffDetails().toString());
            }
        }
        if (actionData.getEncryptionKey() != null) {
            try {
                serialized = EncryptUtil.base64Encode(EncryptUtil.encrypt(serialized, actionData.getEncryptionKey(), true));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to perform symmetric encryption", e);
            }
        }
        return new BodyAndKeywords(serialized, keywords);
    }
}

