/*
 * Decompiled with CFR 0.152.
 */
package com.logsentinel.api;

import com.logsentinel.ApiClient;
import com.logsentinel.ApiException;
import com.logsentinel.ApiResponse;
import com.logsentinel.Configuration;
import com.logsentinel.Pair;
import com.logsentinel.model.UpdateUserRequest;
import com.logsentinel.model.UserDetails;
import com.logsentinel.model.UserRegistrationRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.ws.rs.core.GenericType;

public class OrganizationUsersApi {
    private ApiClient apiClient;

    public OrganizationUsersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrganizationUsersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UserDetails changeRole(String role, UUID userId) throws ApiException {
        return this.changeRoleWithHttpInfo(role, userId).getData();
    }

    public ApiResponse<UserDetails> changeRoleWithHttpInfo(String role, UUID userId) throws ApiException {
        Object localVarPostBody = null;
        if (role == null) {
            throw new ApiException(400, "Missing the required parameter 'role' when calling changeRole");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling changeRole");
        }
        String localVarPath = "/api/users/userId/{userId}/changeRole/{role}".replaceAll("\\{role\\}", this.apiClient.escapeString(role.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<UserDetails> localVarReturnType = new GenericType<UserDetails>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserDetails create(UserRegistrationRequest request) throws ApiException {
        return this.createWithHttpInfo(request).getData();
    }

    public ApiResponse<UserDetails> createWithHttpInfo(UserRegistrationRequest request) throws ApiException {
        UserRegistrationRequest localVarPostBody = request;
        if (request == null) {
            throw new ApiException(400, "Missing the required parameter 'request' when calling create");
        }
        String localVarPath = "/api/users/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<UserDetails> localVarReturnType = new GenericType<UserDetails>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserDetails forgetUser(UUID userId) throws ApiException {
        return this.forgetUserWithHttpInfo(userId).getData();
    }

    public ApiResponse<UserDetails> forgetUserWithHttpInfo(UUID userId) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling forgetUser");
        }
        String localVarPath = "/api/users/forget/{userId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<UserDetails> localVarReturnType = new GenericType<UserDetails>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserDetails getUserDetailsByEmail(String email) throws ApiException {
        return this.getUserDetailsByEmailWithHttpInfo(email).getData();
    }

    public ApiResponse<UserDetails> getUserDetailsByEmailWithHttpInfo(String email) throws ApiException {
        Object localVarPostBody = null;
        if (email == null) {
            throw new ApiException(400, "Missing the required parameter 'email' when calling getUserDetailsByEmail");
        }
        String localVarPath = "/api/users/email/{email}".replaceAll("\\{email\\}", this.apiClient.escapeString(email.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<UserDetails> localVarReturnType = new GenericType<UserDetails>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserDetails getUserDetailsById(UUID userId) throws ApiException {
        return this.getUserDetailsByIdWithHttpInfo(userId).getData();
    }

    public ApiResponse<UserDetails> getUserDetailsByIdWithHttpInfo(UUID userId) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getUserDetailsById");
        }
        String localVarPath = "/api/users/userId/{userId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<UserDetails> localVarReturnType = new GenericType<UserDetails>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserDetails update(UpdateUserRequest request) throws ApiException {
        return this.updateWithHttpInfo(request).getData();
    }

    public ApiResponse<UserDetails> updateWithHttpInfo(UpdateUserRequest request) throws ApiException {
        UpdateUserRequest localVarPostBody = request;
        if (request == null) {
            throw new ApiException(400, "Missing the required parameter 'request' when calling update");
        }
        String localVarPath = "/api/users/update";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<UserDetails> localVarReturnType = new GenericType<UserDetails>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

