/*
 * Decompiled with CFR 0.152.
 */
package com.logsentinel.api;

import com.logsentinel.ApiClient;
import com.logsentinel.ApiException;
import com.logsentinel.ApiResponse;
import com.logsentinel.Configuration;
import com.logsentinel.Pair;
import com.logsentinel.model.APICredentialsOrganization;
import com.logsentinel.model.OrganizationDto;
import com.logsentinel.model.RegistrationResponse;
import com.logsentinel.model.UserRegistrationRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.core.GenericType;

public class PartnersApi {
    private ApiClient apiClient;

    public PartnersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PartnersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void cancelOrganization(UUID organizationId) throws ApiException {
        this.cancelOrganizationWithHttpInfo(organizationId);
    }

    public ApiResponse<Void> cancelOrganizationWithHttpInfo(UUID organizationId) throws ApiException {
        Object localVarPostBody = null;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling cancelOrganization");
        }
        String localVarPath = "/api/partner/organizations/cancel";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "organizationId", organizationId));
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<UUID> fetchAllOrganizations() throws ApiException {
        return this.fetchAllOrganizationsWithHttpInfo().getData();
    }

    public ApiResponse<List<UUID>> fetchAllOrganizationsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/partner/organizations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<List<UUID>> localVarReturnType = new GenericType<List<UUID>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Map<String, List<APICredentialsOrganization>> getApiCredentials() throws ApiException {
        return this.getApiCredentialsWithHttpInfo().getData();
    }

    public ApiResponse<Map<String, List<APICredentialsOrganization>>> getApiCredentialsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/partner/organizations/apiCredentials";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<Map<String, List<APICredentialsOrganization>>> localVarReturnType = new GenericType<Map<String, List<APICredentialsOrganization>>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OrganizationDto getOrganizationByUserEmail(String email) throws ApiException {
        return this.getOrganizationByUserEmailWithHttpInfo(email).getData();
    }

    public ApiResponse<OrganizationDto> getOrganizationByUserEmailWithHttpInfo(String email) throws ApiException {
        Object localVarPostBody = null;
        if (email == null) {
            throw new ApiException(400, "Missing the required parameter 'email' when calling getOrganizationByUserEmail");
        }
        String localVarPath = "/api/partner/organizationByUserEmail";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "email", email));
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<OrganizationDto> localVarReturnType = new GenericType<OrganizationDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RegistrationResponse registerUser(UserRegistrationRequest request) throws ApiException {
        return this.registerUserWithHttpInfo(request).getData();
    }

    public ApiResponse<RegistrationResponse> registerUserWithHttpInfo(UserRegistrationRequest request) throws ApiException {
        UserRegistrationRequest localVarPostBody = request;
        if (request == null) {
            throw new ApiException(400, "Missing the required parameter 'request' when calling registerUser");
        }
        String localVarPath = "/api/partner/user/register";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<RegistrationResponse> localVarReturnType = new GenericType<RegistrationResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

