/*
 * Decompiled with CFR 0.152.
 */
package com.logsentinel.api;

import com.logsentinel.ApiClient;
import com.logsentinel.ApiException;
import com.logsentinel.ApiResponse;
import com.logsentinel.Configuration;
import com.logsentinel.Pair;
import com.logsentinel.model.AuditLogEntry;
import com.logsentinel.model.SearchRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class SearchApi {
    private ApiClient apiClient;

    public SearchApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SearchApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public List<AuditLogEntry> getBatch(String applicationId, String field, List<String> values, Integer batchSize, String entityType, Integer page) throws ApiException {
        return this.getBatchWithHttpInfo(applicationId, field, values, batchSize, entityType, page).getData();
    }

    public ApiResponse<List<AuditLogEntry>> getBatchWithHttpInfo(String applicationId, String field, List<String> values, Integer batchSize, String entityType, Integer page) throws ApiException {
        Object localVarPostBody = null;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getBatch");
        }
        if (field == null) {
            throw new ApiException(400, "Missing the required parameter 'field' when calling getBatch");
        }
        if (values == null) {
            throw new ApiException(400, "Missing the required parameter 'values' when calling getBatch");
        }
        String localVarPath = "/api/search/batch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batchSize", batchSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "entityType", entityType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "field", field));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "values", values));
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<List<AuditLogEntry>> localVarReturnType = new GenericType<List<AuditLogEntry>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<AuditLogEntry> getEntityHistory(String applicationId, String entityId, String entityType) throws ApiException {
        return this.getEntityHistoryWithHttpInfo(applicationId, entityId, entityType).getData();
    }

    public ApiResponse<List<AuditLogEntry>> getEntityHistoryWithHttpInfo(String applicationId, String entityId, String entityType) throws ApiException {
        Object localVarPostBody = null;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getEntityHistory");
        }
        if (entityId == null) {
            throw new ApiException(400, "Missing the required parameter 'entityId' when calling getEntityHistory");
        }
        if (entityType == null) {
            throw new ApiException(400, "Missing the required parameter 'entityType' when calling getEntityHistory");
        }
        String localVarPath = "/api/search/entityHistory";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "entityId", entityId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "entityType", entityType));
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<List<AuditLogEntry>> localVarReturnType = new GenericType<List<AuditLogEntry>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<AuditLogEntry> search(String applicationId, SearchRequest searchRequest) throws ApiException {
        return this.searchWithHttpInfo(applicationId, searchRequest).getData();
    }

    public ApiResponse<List<AuditLogEntry>> searchWithHttpInfo(String applicationId, SearchRequest searchRequest) throws ApiException {
        SearchRequest localVarPostBody = searchRequest;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling search");
        }
        if (searchRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'searchRequest' when calling search");
        }
        String localVarPath = "/api/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<List<AuditLogEntry>> localVarReturnType = new GenericType<List<AuditLogEntry>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

