/*
 * Decompiled with CFR 0.152.
 */
package com.logsentinel.api;

import com.logsentinel.ApiClient;
import com.logsentinel.ApiException;
import com.logsentinel.ApiResponse;
import com.logsentinel.Configuration;
import com.logsentinel.Pair;
import com.logsentinel.model.AuditLogEntry;
import com.logsentinel.model.ConsistencyProof;
import com.logsentinel.model.EthereumData;
import com.logsentinel.model.InclusionProof;
import com.logsentinel.model.MerkleTreeInfo;
import com.logsentinel.model.ResolvedVerificationFailureResponse;
import com.logsentinel.model.TreeHead;
import com.logsentinel.model.Verification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.GenericType;

public class VerificationApi {
    private ApiClient apiClient;

    public VerificationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VerificationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ConsistencyProof getConsistencyProof(UUID applicationId, String firstTreeHash, String secondTreeHash) throws ApiException {
        return this.getConsistencyProofWithHttpInfo(applicationId, firstTreeHash, secondTreeHash).getData();
    }

    public ApiResponse<ConsistencyProof> getConsistencyProofWithHttpInfo(UUID applicationId, String firstTreeHash, String secondTreeHash) throws ApiException {
        Object localVarPostBody = null;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getConsistencyProof");
        }
        if (firstTreeHash == null) {
            throw new ApiException(400, "Missing the required parameter 'firstTreeHash' when calling getConsistencyProof");
        }
        String localVarPath = "/api/verification/merkle/proofs/consistency";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "firstTreeHash", firstTreeHash));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "secondTreeHash", secondTreeHash));
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<ConsistencyProof> localVarReturnType = new GenericType<ConsistencyProof>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<AuditLogEntry> getEntriesBetweenHashes(UUID applicationId, String endHash, String startHash) throws ApiException {
        return this.getEntriesBetweenHashesWithHttpInfo(applicationId, endHash, startHash).getData();
    }

    public ApiResponse<List<AuditLogEntry>> getEntriesBetweenHashesWithHttpInfo(UUID applicationId, String endHash, String startHash) throws ApiException {
        Object localVarPostBody = null;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getEntriesBetweenHashes");
        }
        if (endHash == null) {
            throw new ApiException(400, "Missing the required parameter 'endHash' when calling getEntriesBetweenHashes");
        }
        if (startHash == null) {
            throw new ApiException(400, "Missing the required parameter 'startHash' when calling getEntriesBetweenHashes");
        }
        String localVarPath = "/api/verification/entries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "endHash", endHash));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "startHash", startHash));
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<List<AuditLogEntry>> localVarReturnType = new GenericType<List<AuditLogEntry>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<EthereumData> getEthereumEntries(UUID applicationId) throws ApiException {
        return this.getEthereumEntriesWithHttpInfo(applicationId).getData();
    }

    public ApiResponse<List<EthereumData>> getEthereumEntriesWithHttpInfo(UUID applicationId) throws ApiException {
        Object localVarPostBody = null;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getEthereumEntries");
        }
        String localVarPath = "/api/verification/ethereumEntries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "applicationId", applicationId));
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<List<EthereumData>> localVarReturnType = new GenericType<List<EthereumData>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public InclusionProof getInclusionProof(UUID applicationId, String hash) throws ApiException {
        return this.getInclusionProofWithHttpInfo(applicationId, hash).getData();
    }

    public ApiResponse<InclusionProof> getInclusionProofWithHttpInfo(UUID applicationId, String hash) throws ApiException {
        Object localVarPostBody = null;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getInclusionProof");
        }
        if (hash == null) {
            throw new ApiException(400, "Missing the required parameter 'hash' when calling getInclusionProof");
        }
        String localVarPath = "/api/verification/merkle/proofs/inclusion";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "hash", hash));
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<InclusionProof> localVarReturnType = new GenericType<InclusionProof>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TreeHead getLatestTreeHead(UUID applicationId) throws ApiException {
        return this.getLatestTreeHeadWithHttpInfo(applicationId).getData();
    }

    public ApiResponse<TreeHead> getLatestTreeHeadWithHttpInfo(UUID applicationId) throws ApiException {
        Object localVarPostBody = null;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getLatestTreeHead");
        }
        String localVarPath = "/api/verification/merkle/latestTreeHead";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<TreeHead> localVarReturnType = new GenericType<TreeHead>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MerkleTreeInfo getMerkleTreeInfo() throws ApiException {
        return this.getMerkleTreeInfoWithHttpInfo().getData();
    }

    public ApiResponse<MerkleTreeInfo> getMerkleTreeInfoWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/verification/merkle/info";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<MerkleTreeInfo> localVarReturnType = new GenericType<MerkleTreeInfo>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ResolvedVerificationFailureResponse> getResolvedVerificationFailures(UUID applicationId) throws ApiException {
        return this.getResolvedVerificationFailuresWithHttpInfo(applicationId).getData();
    }

    public ApiResponse<List<ResolvedVerificationFailureResponse>> getResolvedVerificationFailuresWithHttpInfo(UUID applicationId) throws ApiException {
        Object localVarPostBody = null;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getResolvedVerificationFailures");
        }
        String localVarPath = "/api/verification/resolved-failures";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<List<ResolvedVerificationFailureResponse>> localVarReturnType = new GenericType<List<ResolvedVerificationFailureResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Verification verify(String applicationId, String hash) throws ApiException {
        return this.verifyWithHttpInfo(applicationId, hash).getData();
    }

    public ApiResponse<Verification> verifyWithHttpInfo(String applicationId, String hash) throws ApiException {
        Object localVarPostBody = null;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling verify");
        }
        if (hash == null) {
            throw new ApiException(400, "Missing the required parameter 'hash' when calling verify");
        }
        String localVarPath = "/api/verification/verify";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "hash", hash));
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<Verification> localVarReturnType = new GenericType<Verification>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Verification verifyEntry(String applicationId, String entryId) throws ApiException {
        return this.verifyEntryWithHttpInfo(applicationId, entryId).getData();
    }

    public ApiResponse<Verification> verifyEntryWithHttpInfo(String applicationId, String entryId) throws ApiException {
        Object localVarPostBody = null;
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling verifyEntry");
        }
        if (entryId == null) {
            throw new ApiException(400, "Missing the required parameter 'entryId' when calling verifyEntry");
        }
        String localVarPath = "/api/verification/verifyEntry";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "entryId", entryId));
        if (applicationId != null) {
            localVarHeaderParams.put("Application-Id", this.apiClient.parameterToString(applicationId));
        }
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        GenericType<Verification> localVarReturnType = new GenericType<Verification>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

