/*
 * Decompiled with CFR 0.152.
 */
package com.logsentinel.enums;

import com.logsentinel.model.AuditLogEntry;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public enum HashableContent {
    BASE(1, HashableContent.baseHashableContent());

    private int version;
    private Function<AuditLogEntry, String> contentExtractor;

    private HashableContent(int version, Function<AuditLogEntry, String> contentExtractor) {
        this.version = version;
        this.contentExtractor = contentExtractor;
    }

    public static HashableContent fromVersion(int version) {
        for (HashableContent hc : HashableContent.values()) {
            if (hc.version != version) continue;
            return hc;
        }
        throw new IllegalArgumentException("unsupported version: " + version);
    }

    public Function<AuditLogEntry, String> getContentExtractor() {
        return this.contentExtractor;
    }

    private static Function<AuditLogEntry, String> baseHashableContent() {
        return entry -> StringUtils.trimToEmpty((String)entry.getActorId()) + StringUtils.trimToEmpty((String)(entry.getActorRoles() == null ? "" : StringUtils.join(entry.getActorRoles(), (String)","))) + StringUtils.trimToEmpty((String)entry.getAction()) + StringUtils.trimToEmpty((String)entry.getEntityId()) + StringUtils.trimToEmpty((String)entry.getEntityType()) + StringUtils.trimToEmpty((String)entry.getDetails()) + StringUtils.trimToEmpty((String)String.valueOf(entry.getTimestamp())) + StringUtils.trimToEmpty((String)(entry.getApplicationId() == null ? "" : entry.getApplicationId().toString())) + StringUtils.trimToEmpty((String)entry.getEntryType()) + (entry.getAdditionalParams() == null ? "" : entry.getAdditionalParams().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue() + "|").reduce("", String::concat));
    }
}

