/*
 * Decompiled with CFR 0.152.
 */
package com.logsentinel.logging;

import com.logsentinel.ApiException;
import com.logsentinel.JSON;
import com.logsentinel.JsonBodySerializer;
import com.logsentinel.LogSentinelClient;
import com.logsentinel.LogSentinelClientBuilder;
import com.logsentinel.model.ActionData;
import com.logsentinel.model.ActorData;
import com.logsentinel.model.LogResponse;
import java.util.ArrayList;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogSentinelAppender {
    private static final String CREDIT_CARD_REGEX = "\\b(?:\\d[ -]*?){16}\\b";
    private static final Pattern CREDIT_CARD_PATTERN = Pattern.compile("\\b(?:\\d[ -]*?){16}\\b");
    private static final String EMAIL_REGEX = "\\b[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}\\b";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("\\b[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}\\b");
    private static final String IP_REGEX = "\\b(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\b";
    private static final Pattern IP_PATTERN = Pattern.compile("\\b(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\b");
    private String basePath;
    private String applicationId;
    private String organizationId;
    private String secret;
    private boolean maskCreditCard;
    private boolean maskIP;
    private boolean maskEmail;
    private boolean async = true;
    private String actorIdRegex;
    private String actorNameRegex;
    private String actionRegex;
    private String entityRegex;
    private Pattern actorIdPattern;
    private Pattern actorNamePattern;
    private Pattern actionPattern;
    private Pattern entityPattern;
    LogSentinelClient client;

    private LogSentinelAppender(String basePath, String applicationId, String organizationId, String secret, boolean maskCreditCard, boolean maskIP, boolean maskEmail, boolean async, String actorIdRegex, String actorNameRegex, String actionRegex, String entityRegex) {
        this.basePath = basePath;
        this.applicationId = applicationId;
        this.organizationId = organizationId;
        this.secret = secret;
        this.maskCreditCard = maskCreditCard;
        this.maskIP = maskIP;
        this.maskEmail = maskEmail;
        this.async = async;
        this.actorIdRegex = actorIdRegex;
        this.actorNameRegex = actorNameRegex;
        this.actionRegex = actionRegex;
        this.entityRegex = entityRegex;
        LogSentinelClientBuilder builder = LogSentinelClientBuilder.create(applicationId, organizationId, secret);
        builder.setBasePath(basePath);
        builder.setBodySerializer(new JsonBodySerializer(new JSON()));
        if (async) {
            builder.setAsync(true);
        }
        this.client = builder.build();
        if (actorIdRegex != null) {
            this.actorIdPattern = Pattern.compile(actorIdRegex);
        }
        if (actorNameRegex != null) {
            this.actorNamePattern = Pattern.compile(actorNameRegex);
        }
        if (actionRegex != null) {
            this.actionPattern = Pattern.compile(actionRegex);
        }
        if (entityRegex != null) {
            this.entityPattern = Pattern.compile(entityRegex);
        }
    }

    public void append(String msg) {
        if (this.maskCreditCard) {
            msg = this.hideCreditCard(msg);
        }
        if (this.maskEmail) {
            msg = this.hideEmail(msg);
        }
        if (this.maskIP) {
            msg = this.hideIP(msg);
        }
        ActorData actorData = new ActorData().actorId(this.extractActorId(msg)).actorDisplayName(this.extractActorName(msg)).actorRoles(new ArrayList<String>());
        ActionData<String> actionData = new ActionData<String>().details(msg).action(this.extractAction(msg)).entityId(this.extractEntity(msg)).binaryContent(false);
        try {
            if (this.async) {
                this.client.getAuditLogActions().log(actorData, actionData, UUID.fromString(this.applicationId));
            } else {
                LogResponse logResponse = this.client.getAuditLogActions().log(actorData, actionData, UUID.fromString(this.applicationId));
            }
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
    }

    private String hideCreditCard(String unmasked) {
        Matcher matcher = CREDIT_CARD_PATTERN.matcher(unmasked);
        if (matcher.find()) {
            return matcher.replaceAll("<credit card>");
        }
        return unmasked;
    }

    private String hideIP(String unmasked) {
        Matcher matcher = IP_PATTERN.matcher(unmasked);
        if (matcher.find()) {
            return matcher.replaceAll("<ip address>");
        }
        return unmasked;
    }

    private String hideEmail(String unmasked) {
        Matcher matcher = EMAIL_PATTERN.matcher(unmasked);
        if (matcher.find()) {
            return matcher.replaceAll("<e-mail>");
        }
        return unmasked;
    }

    private String extractActorId(String msg) {
        if (this.actorIdPattern == null) {
            return "";
        }
        Matcher matcher = this.actorIdPattern.matcher(msg);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    private String extractActorName(String msg) {
        if (this.actorNamePattern == null) {
            return "";
        }
        Matcher matcher = this.actorNamePattern.matcher(msg);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    private String extractAction(String msg) {
        if (this.actionPattern == null) {
            return "";
        }
        Matcher matcher = this.actionPattern.matcher(msg);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    private String extractEntity(String msg) {
        if (this.entityPattern == null) {
            return "";
        }
        Matcher matcher = this.entityPattern.matcher(msg);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static class LogSentinelAppenderBuilder {
        private String basePath;
        private String applicationId;
        private String organizationId;
        private String secret;
        private boolean maskCreditCard;
        private boolean maskIP;
        private boolean maskEmail;
        private boolean async = true;
        private String actorIdRegex;
        private String actorNameRegex;
        private String actionRegex;
        private String entityRegex;

        public LogSentinelAppender build() {
            return new LogSentinelAppender(this.basePath, this.applicationId, this.organizationId, this.secret, this.maskCreditCard, this.maskIP, this.maskEmail, this.async, this.actorIdRegex, this.actorNameRegex, this.actionRegex, this.entityRegex);
        }

        public LogSentinelAppenderBuilder setBasePath(String arg) {
            this.basePath = arg;
            return this;
        }

        public LogSentinelAppenderBuilder setApplicationId(String arg) {
            this.applicationId = arg;
            return this;
        }

        public LogSentinelAppenderBuilder setOrganizationId(String arg) {
            this.organizationId = arg;
            return this;
        }

        public LogSentinelAppenderBuilder setSecret(String arg) {
            this.secret = arg;
            return this;
        }

        public LogSentinelAppenderBuilder setMaskCreditCard(boolean arg) {
            this.maskCreditCard = arg;
            return this;
        }

        public LogSentinelAppenderBuilder setMaskIp(boolean arg) {
            this.maskIP = arg;
            return this;
        }

        public LogSentinelAppenderBuilder setMaskEmail(boolean arg) {
            this.maskEmail = arg;
            return this;
        }

        public LogSentinelAppenderBuilder setAsync(boolean arg) {
            this.async = arg;
            return this;
        }

        public LogSentinelAppenderBuilder setActorIdRegex(String arg) {
            this.actorIdRegex = arg;
            return this;
        }

        public LogSentinelAppenderBuilder setActorNameRegex(String arg) {
            this.actorNameRegex = arg;
            return this;
        }

        public LogSentinelAppenderBuilder setActionRegex(String arg) {
            this.actionRegex = arg;
            return this;
        }

        public LogSentinelAppenderBuilder setEntityRegex(String arg) {
            this.entityRegex = arg;
            return this;
        }
    }
}

