/*
 * Decompiled with CFR 0.152.
 */
package com.logsentinel.merkletree.utils;

public class TreeUtils {
    public static int calculateInclusionProofSize(int treeSize, int leafIndex) {
        int length = 0;
        double lastNode = treeSize - 1;
        double tmpIndex = leafIndex;
        while (lastNode > 0.0) {
            if (tmpIndex % 2.0 > 0.0 || tmpIndex < lastNode) {
                ++length;
            }
            tmpIndex = Math.floor(tmpIndex / 2.0);
            lastNode = Math.floor(lastNode / 2.0);
        }
        return length;
    }

    public static int calculateConsistencyProofSize(int firstTreeSize, int secondTreeSize) {
        int length = 0;
        int b = 0;
        double m = firstTreeSize;
        double n = secondTreeSize;
        while (m != n) {
            ++length;
            double k = Math.pow(2.0, Math.floor(Math.log(n - 1.0) / Math.log(2.0)));
            if (m <= k) {
                n = k;
                continue;
            }
            m -= k;
            n -= k;
            b = 1;
        }
        return length += b;
    }
}

