/*
 * Decompiled with CFR 0.152.
 */
package com.logsentinel.merkletree.verification;

import com.logsentinel.merkletree.utils.ArrayUtils;
import com.logsentinel.merkletree.utils.CryptoUtils;
import com.logsentinel.merkletree.verification.FnSn;
import java.util.Arrays;
import java.util.List;

public class ConsistencyProofVerifier {
    public static Boolean verify(List<byte[]> consistencyProof, byte[] firstHash, int treeSizeFirst, byte[] secondHash, int treeSizeSecond) {
        if (treeSizeFirst > treeSizeSecond) {
            return false;
        }
        if (Arrays.equals(firstHash, secondHash) && treeSizeFirst == treeSizeSecond) {
            return true;
        }
        if (consistencyProof.size() == 0) {
            return false;
        }
        if ((treeSizeFirst & treeSizeFirst - 1) == 0) {
            consistencyProof.add(0, firstHash);
        }
        int fn = treeSizeFirst - 1;
        int sn = treeSizeSecond - 1;
        if ((fn & 1) == 1) {
            FnSn fnSn = ConsistencyProofVerifier.rightShiftFnSnUntilLsbFnUnset(fn, sn);
            fn = fnSn.getFn();
            sn = fnSn.getSn();
        }
        byte[] fr = consistencyProof.get(0);
        byte[] sr = consistencyProof.get(0);
        for (byte[] c : consistencyProof.subList(1, consistencyProof.size())) {
            if (sn == 0) {
                return false;
            }
            if (fr == null || sr == null) {
                return false;
            }
            if (fn == sn || (fn & 1) == 1) {
                fr = CryptoUtils.hash(ArrayUtils.addByteToArray(ArrayUtils.concat(c, fr), (byte)1));
                sr = CryptoUtils.hash(ArrayUtils.addByteToArray(ArrayUtils.concat(c, sr), (byte)1));
                if ((fn & 1) == 0) {
                    FnSn fnSn = ConsistencyProofVerifier.rightShiftFnSnUntilLsbFnSetOrFnZ(fn, sn);
                    fn = fnSn.getFn();
                    sn = fnSn.getSn();
                }
            } else {
                sr = CryptoUtils.hash(ArrayUtils.addByteToArray(ArrayUtils.concat(sr, c), (byte)1));
            }
            fn >>= 1;
            sn >>= 1;
        }
        return Arrays.equals(fr, firstHash) && Arrays.equals(sr, secondHash) && sn == 0;
    }

    private static FnSn rightShiftFnSnUntilLsbFnUnset(int fn, int sn) {
        do {
            sn >>= 1;
        } while (((fn >>= 1) & 1) == 1);
        FnSn fnSn = new FnSn();
        FnSn.setFn(fn);
        FnSn.setSn(sn);
        return fnSn;
    }

    private static FnSn rightShiftFnSnUntilLsbFnSetOrFnZ(int fn, int sn) {
        do {
            sn >>= 1;
        } while (((fn >>= 1) & 1) == 0 && fn != 0);
        FnSn fnSn = new FnSn();
        FnSn.setFn(fn);
        FnSn.setSn(sn);
        return fnSn;
    }
}

