/*
 * Decompiled with CFR 0.152.
 */
package com.logsentinel.merkletree.verification;

import com.logsentinel.merkletree.utils.ArrayUtils;
import com.logsentinel.merkletree.utils.CryptoUtils;
import com.logsentinel.merkletree.verification.FnSn;
import java.util.Arrays;
import java.util.List;

public class InclusionProofVerifier {
    public static Boolean verify(List<byte[]> path, byte[] hash, int leafIndex, int treeSize, byte[] rootHash) {
        if (leafIndex > treeSize) {
            return false;
        }
        int fn = leafIndex;
        int sn = treeSize - 1;
        byte[] r = hash;
        for (byte[] p : path) {
            if (sn == 0) {
                return false;
            }
            if (fn == sn || (fn & 1) == 1) {
                r = CryptoUtils.hash(ArrayUtils.addByteToArray(ArrayUtils.concat(p, r), (byte)1));
                if ((fn & 1) == 0) {
                    FnSn fnSn = InclusionProofVerifier.rightShiftFnSnUntilLsbFnSetOrFnZ(fn, sn);
                    fn = fnSn.getFn();
                    sn = fnSn.getSn();
                }
            } else {
                r = CryptoUtils.hash(ArrayUtils.addByteToArray(ArrayUtils.concat(r, p), (byte)1));
            }
            sn >>= 1;
            fn >>= 1;
        }
        return sn == 0 && Arrays.equals(r, rootHash);
    }

    private static FnSn rightShiftFnSnUntilLsbFnSetOrFnZ(int fn, int sn) {
        do {
            sn >>= 1;
        } while (((fn >>= 1) & 1) == 0 && fn != 0);
        FnSn fnSn = new FnSn();
        FnSn.setFn(fn);
        FnSn.setSn(sn);
        return fnSn;
    }
}

