/*
 * Decompiled with CFR 0.152.
 */
package com.logsentinel.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.logsentinel.enums.HashableContent;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AuditLogEntry {
    @JsonProperty(value="action")
    private String action = null;
    @JsonProperty(value="actorDisplayName")
    private String actorDisplayName = null;
    @JsonProperty(value="actorId")
    private String actorId = null;
    @JsonProperty(value="actorRoles")
    private List<String> actorRoles = null;
    @JsonProperty(value="additionalParams")
    private Map<String, String> additionalParams = null;
    @JsonProperty(value="applicationId")
    private UUID applicationId = null;
    @JsonProperty(value="details")
    private String details = null;
    @JsonProperty(value="encryptedKeywordsList")
    private List<String> encryptedKeywordsList = null;
    @JsonProperty(value="entityId")
    private String entityId = null;
    @JsonProperty(value="entityType")
    private String entityType = null;
    @JsonProperty(value="entryType")
    private String entryType = null;
    @JsonProperty(value="hash")
    private String hash = null;
    @JsonProperty(value="hashVersion")
    private Integer hashVersion = null;
    @JsonProperty(value="id")
    private UUID id = null;
    @JsonProperty(value="insideWorkingHours")
    private Boolean insideWorkingHours = null;
    @JsonProperty(value="ipAddress")
    private String ipAddress = null;
    @JsonProperty(value="logLevel")
    private LogLevelEnum logLevel = null;
    @JsonProperty(value="numericParams")
    private Map<String, Double> numericParams = null;
    @JsonProperty(value="originalEventTimestamp")
    private Long originalEventTimestamp = null;
    @JsonProperty(value="previousEntryId")
    private UUID previousEntryId = null;
    @JsonProperty(value="standaloneHash")
    private String standaloneHash = null;
    @JsonProperty(value="timestamp")
    private Long timestamp = null;
    @JsonProperty(value="timestampGroupHash")
    private String timestampGroupHash = null;
    @JsonProperty(value="timestampGroupSize")
    private Integer timestampGroupSize = null;
    @JsonProperty(value="timestampTime")
    private LocalDateTime timestampTime = null;
    @JsonProperty(value="timestampTokenId")
    private UUID timestampTokenId = null;

    public AuditLogEntry action(String action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(value="")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public AuditLogEntry actorDisplayName(String actorDisplayName) {
        this.actorDisplayName = actorDisplayName;
        return this;
    }

    @ApiModelProperty(value="")
    public String getActorDisplayName() {
        return this.actorDisplayName;
    }

    public void setActorDisplayName(String actorDisplayName) {
        this.actorDisplayName = actorDisplayName;
    }

    public AuditLogEntry actorId(String actorId) {
        this.actorId = actorId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getActorId() {
        return this.actorId;
    }

    public void setActorId(String actorId) {
        this.actorId = actorId;
    }

    public AuditLogEntry actorRoles(List<String> actorRoles) {
        this.actorRoles = actorRoles;
        return this;
    }

    public AuditLogEntry addActorRolesItem(String actorRolesItem) {
        if (this.actorRoles == null) {
            this.actorRoles = new ArrayList<String>();
        }
        this.actorRoles.add(actorRolesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getActorRoles() {
        return this.actorRoles;
    }

    public void setActorRoles(List<String> actorRoles) {
        this.actorRoles = actorRoles;
    }

    public AuditLogEntry additionalParams(Map<String, String> additionalParams) {
        this.additionalParams = additionalParams;
        return this;
    }

    public AuditLogEntry putAdditionalParamsItem(String key, String additionalParamsItem) {
        if (this.additionalParams == null) {
            this.additionalParams = new HashMap<String, String>();
        }
        this.additionalParams.put(key, additionalParamsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public Map<String, String> getAdditionalParams() {
        return this.additionalParams;
    }

    public void setAdditionalParams(Map<String, String> additionalParams) {
        this.additionalParams = additionalParams;
    }

    public AuditLogEntry applicationId(UUID applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @ApiModelProperty(value="")
    public UUID getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(UUID applicationId) {
        this.applicationId = applicationId;
    }

    public AuditLogEntry details(String details) {
        this.details = details;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public AuditLogEntry encryptedKeywordsList(List<String> encryptedKeywordsList) {
        this.encryptedKeywordsList = encryptedKeywordsList;
        return this;
    }

    public AuditLogEntry addEncryptedKeywordsListItem(String encryptedKeywordsListItem) {
        if (this.encryptedKeywordsList == null) {
            this.encryptedKeywordsList = new ArrayList<String>();
        }
        this.encryptedKeywordsList.add(encryptedKeywordsListItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getEncryptedKeywordsList() {
        return this.encryptedKeywordsList;
    }

    public void setEncryptedKeywordsList(List<String> encryptedKeywordsList) {
        this.encryptedKeywordsList = encryptedKeywordsList;
    }

    public AuditLogEntry entityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public AuditLogEntry entityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    @ApiModelProperty(value="")
    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public AuditLogEntry entryType(String entryType) {
        this.entryType = entryType;
        return this;
    }

    @ApiModelProperty(value="")
    public String getEntryType() {
        return this.entryType;
    }

    public void setEntryType(String entryType) {
        this.entryType = entryType;
    }

    public AuditLogEntry hash(String hash) {
        this.hash = hash;
        return this;
    }

    @ApiModelProperty(value="")
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public AuditLogEntry hashVersion(Integer hashVersion) {
        this.hashVersion = hashVersion;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getHashVersion() {
        return this.hashVersion;
    }

    public void setHashVersion(Integer hashVersion) {
        this.hashVersion = hashVersion;
    }

    public AuditLogEntry id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public AuditLogEntry insideWorkingHours(Boolean insideWorkingHours) {
        this.insideWorkingHours = insideWorkingHours;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isInsideWorkingHours() {
        return this.insideWorkingHours;
    }

    public void setInsideWorkingHours(Boolean insideWorkingHours) {
        this.insideWorkingHours = insideWorkingHours;
    }

    public AuditLogEntry ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public AuditLogEntry logLevel(LogLevelEnum logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    @ApiModelProperty(value="")
    public LogLevelEnum getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevelEnum logLevel) {
        this.logLevel = logLevel;
    }

    public AuditLogEntry numericParams(Map<String, Double> numericParams) {
        this.numericParams = numericParams;
        return this;
    }

    public AuditLogEntry putNumericParamsItem(String key, Double numericParamsItem) {
        if (this.numericParams == null) {
            this.numericParams = new HashMap<String, Double>();
        }
        this.numericParams.put(key, numericParamsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public Map<String, Double> getNumericParams() {
        return this.numericParams;
    }

    public void setNumericParams(Map<String, Double> numericParams) {
        this.numericParams = numericParams;
    }

    public AuditLogEntry originalEventTimestamp(Long originalEventTimestamp) {
        this.originalEventTimestamp = originalEventTimestamp;
        return this;
    }

    @ApiModelProperty(value="")
    public Long getOriginalEventTimestamp() {
        return this.originalEventTimestamp;
    }

    public void setOriginalEventTimestamp(Long originalEventTimestamp) {
        this.originalEventTimestamp = originalEventTimestamp;
    }

    public AuditLogEntry previousEntryId(UUID previousEntryId) {
        this.previousEntryId = previousEntryId;
        return this;
    }

    @ApiModelProperty(value="")
    public UUID getPreviousEntryId() {
        return this.previousEntryId;
    }

    public void setPreviousEntryId(UUID previousEntryId) {
        this.previousEntryId = previousEntryId;
    }

    public AuditLogEntry standaloneHash(String standaloneHash) {
        this.standaloneHash = standaloneHash;
        return this;
    }

    @ApiModelProperty(value="")
    public String getStandaloneHash() {
        return this.standaloneHash;
    }

    public void setStandaloneHash(String standaloneHash) {
        this.standaloneHash = standaloneHash;
    }

    public AuditLogEntry timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(value="")
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public AuditLogEntry timestampGroupHash(String timestampGroupHash) {
        this.timestampGroupHash = timestampGroupHash;
        return this;
    }

    @ApiModelProperty(value="")
    public String getTimestampGroupHash() {
        return this.timestampGroupHash;
    }

    public void setTimestampGroupHash(String timestampGroupHash) {
        this.timestampGroupHash = timestampGroupHash;
    }

    public AuditLogEntry timestampGroupSize(Integer timestampGroupSize) {
        this.timestampGroupSize = timestampGroupSize;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getTimestampGroupSize() {
        return this.timestampGroupSize;
    }

    public void setTimestampGroupSize(Integer timestampGroupSize) {
        this.timestampGroupSize = timestampGroupSize;
    }

    public AuditLogEntry timestampTime(LocalDateTime timestampTime) {
        this.timestampTime = timestampTime;
        return this;
    }

    @ApiModelProperty(value="")
    public LocalDateTime getTimestampTime() {
        return this.timestampTime;
    }

    public void setTimestampTime(LocalDateTime timestampTime) {
        this.timestampTime = timestampTime;
    }

    public AuditLogEntry timestampTokenId(UUID timestampTokenId) {
        this.timestampTokenId = timestampTokenId;
        return this;
    }

    @ApiModelProperty(value="")
    public UUID getTimestampTokenId() {
        return this.timestampTokenId;
    }

    public void setTimestampTokenId(UUID timestampTokenId) {
        this.timestampTokenId = timestampTokenId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogEntry auditLogEntry = (AuditLogEntry)o;
        return Objects.equals(this.action, auditLogEntry.action) && Objects.equals(this.actorDisplayName, auditLogEntry.actorDisplayName) && Objects.equals(this.actorId, auditLogEntry.actorId) && Objects.equals(this.actorRoles, auditLogEntry.actorRoles) && Objects.equals(this.additionalParams, auditLogEntry.additionalParams) && Objects.equals(this.applicationId, auditLogEntry.applicationId) && Objects.equals(this.details, auditLogEntry.details) && Objects.equals(this.encryptedKeywordsList, auditLogEntry.encryptedKeywordsList) && Objects.equals(this.entityId, auditLogEntry.entityId) && Objects.equals(this.entityType, auditLogEntry.entityType) && Objects.equals(this.entryType, auditLogEntry.entryType) && Objects.equals(this.hash, auditLogEntry.hash) && Objects.equals(this.hashVersion, auditLogEntry.hashVersion) && Objects.equals(this.id, auditLogEntry.id) && Objects.equals(this.insideWorkingHours, auditLogEntry.insideWorkingHours) && Objects.equals(this.ipAddress, auditLogEntry.ipAddress) && Objects.equals((Object)this.logLevel, (Object)auditLogEntry.logLevel) && Objects.equals(this.numericParams, auditLogEntry.numericParams) && Objects.equals(this.originalEventTimestamp, auditLogEntry.originalEventTimestamp) && Objects.equals(this.previousEntryId, auditLogEntry.previousEntryId) && Objects.equals(this.standaloneHash, auditLogEntry.standaloneHash) && Objects.equals(this.timestamp, auditLogEntry.timestamp) && Objects.equals(this.timestampGroupHash, auditLogEntry.timestampGroupHash) && Objects.equals(this.timestampGroupSize, auditLogEntry.timestampGroupSize) && Objects.equals(this.timestampTime, auditLogEntry.timestampTime) && Objects.equals(this.timestampTokenId, auditLogEntry.timestampTokenId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.actorDisplayName, this.actorId, this.actorRoles, this.additionalParams, this.applicationId, this.details, this.encryptedKeywordsList, this.entityId, this.entityType, this.entryType, this.hash, this.hashVersion, this.id, this.insideWorkingHours, this.ipAddress, this.logLevel, this.numericParams, this.originalEventTimestamp, this.previousEntryId, this.standaloneHash, this.timestamp, this.timestampGroupHash, this.timestampGroupSize, this.timestampTime, this.timestampTokenId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuditLogEntry {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    actorDisplayName: ").append(this.toIndentedString(this.actorDisplayName)).append("\n");
        sb.append("    actorId: ").append(this.toIndentedString(this.actorId)).append("\n");
        sb.append("    actorRoles: ").append(this.toIndentedString(this.actorRoles)).append("\n");
        sb.append("    additionalParams: ").append(this.toIndentedString(this.additionalParams)).append("\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    encryptedKeywordsList: ").append(this.toIndentedString(this.encryptedKeywordsList)).append("\n");
        sb.append("    entityId: ").append(this.toIndentedString(this.entityId)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString(this.entityType)).append("\n");
        sb.append("    entryType: ").append(this.toIndentedString(this.entryType)).append("\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("    hashVersion: ").append(this.toIndentedString(this.hashVersion)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    insideWorkingHours: ").append(this.toIndentedString(this.insideWorkingHours)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    logLevel: ").append(this.toIndentedString((Object)this.logLevel)).append("\n");
        sb.append("    numericParams: ").append(this.toIndentedString(this.numericParams)).append("\n");
        sb.append("    originalEventTimestamp: ").append(this.toIndentedString(this.originalEventTimestamp)).append("\n");
        sb.append("    previousEntryId: ").append(this.toIndentedString(this.previousEntryId)).append("\n");
        sb.append("    standaloneHash: ").append(this.toIndentedString(this.standaloneHash)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    timestampGroupHash: ").append(this.toIndentedString(this.timestampGroupHash)).append("\n");
        sb.append("    timestampGroupSize: ").append(this.toIndentedString(this.timestampGroupSize)).append("\n");
        sb.append("    timestampTime: ").append(this.toIndentedString(this.timestampTime)).append("\n");
        sb.append("    timestampTokenId: ").append(this.toIndentedString(this.timestampTokenId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String getHashableContent() {
        return HashableContent.fromVersion(this.hashVersion).getContentExtractor().apply(this);
    }

    public static enum LogLevelEnum {
        TRACE("TRACE"),
        DEBUG("DEBUG"),
        INFO("INFO"),
        WARN("WARN"),
        ERROR("ERROR"),
        CRITICAL("CRITICAL"),
        FATAL("FATAL");

        private String value;

        private LogLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LogLevelEnum fromValue(String text) {
            for (LogLevelEnum b : LogLevelEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

