/*
 * Decompiled with CFR 0.152.
 */
package com.logsentinel.util;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.bc.BcRSASignerInfoVerifierBuilder;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;

public class TimeStampUtil {
    public static boolean verifyMthTimeStamp(String mth, String timeStampToken, String signingCertificate) {
        try {
            TimeStampToken tsToken = new TimeStampToken(new CMSSignedData(Base64.getDecoder().decode(timeStampToken)));
            int digestSize = MessageDigest.getInstance(tsToken.getTimeStampInfo().getHashAlgorithm().getAlgorithm().getId()).getDigestLength();
            if (digestSize != tsToken.getTimeStampInfo().getMessageImprintDigest().length) {
                return false;
            }
            if (!mth.equals(Base64.getUrlEncoder().encodeToString(tsToken.getTimeStampInfo().getMessageImprintDigest()).replace("=", ""))) {
                return false;
            }
            X509CertificateHolder holder = new X509CertificateHolder(Base64.getDecoder().decode(signingCertificate));
            BcRSASignerInfoVerifierBuilder verifierBuilder = new BcRSASignerInfoVerifierBuilder((CMSSignatureAlgorithmNameGenerator)new DefaultCMSSignatureAlgorithmNameGenerator(), (SignatureAlgorithmIdentifierFinder)new DefaultSignatureAlgorithmIdentifierFinder(), (DigestAlgorithmIdentifierFinder)new DefaultDigestAlgorithmIdentifierFinder(), (DigestCalculatorProvider)new BcDigestCalculatorProvider());
            return tsToken.isSignatureValid(verifierBuilder.build(holder));
        }
        catch (IOException | IllegalArgumentException | NoSuchAlgorithmException | CMSException | OperatorCreationException | TSPException e) {
            System.err.println("Exception when verifying MTH time stamp token");
            e.printStackTrace();
            return false;
        }
    }
}

