/*
 * Decompiled with CFR 0.152.
 */
package com.logtail.logback;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.logtail.logback.LogtailResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogtailAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    protected String appName;
    protected String ingestUrl = "https://in.logs.betterstack.com";
    protected String sourceToken;
    protected String userAgent = "Better Stack Logback Appender";
    protected List<String> mdcFields = new ArrayList<String>();
    protected List<String> mdcTypes = new ArrayList<String>();
    protected int maxQueueSize = 100000;
    protected int batchSize = 1000;
    protected int batchInterval = 3000;
    protected int connectTimeout = 5000;
    protected int readTimeout = 10000;
    protected int maxRetries = 5;
    protected int retrySleepMilliseconds = 300;
    protected PatternLayoutEncoder encoder;
    protected Vector<ILoggingEvent> batch = new Vector();
    protected AtomicBoolean isFlushing = new AtomicBoolean(false);
    protected boolean mustReflush = false;
    protected boolean warnAboutMaxQueueSize = true;
    protected ScheduledExecutorService scheduledExecutorService;
    protected ScheduledFuture<?> scheduledFuture;
    protected ObjectMapper dataMapper;
    protected Logger logger;
    protected int retrySize = 0;
    protected int retries = 0;
    protected boolean disabled = false;
    protected ThreadFactory threadFactory = r -> {
        Thread thread = Executors.defaultThreadFactory().newThread(r);
        thread.setName("logtail-appender");
        thread.setDaemon(true);
        return thread;
    };

    public LogtailAppender() {
        this.logger = LoggerFactory.getLogger(LogtailAppender.class);
        this.dataMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).setPropertyNamingStrategy(PropertyNamingStrategies.UPPER_CAMEL_CASE).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
        this.scheduledFuture = this.scheduledExecutorService.scheduleWithFixedDelay(new LogtailSender(), this.batchInterval, this.batchInterval, TimeUnit.MILLISECONDS);
    }

    protected void append(ILoggingEvent event) {
        if (this.disabled) {
            return;
        }
        if (event.getLoggerName().equals(LogtailAppender.class.getName())) {
            return;
        }
        if (this.ingestUrl.isEmpty() || this.sourceToken == null || this.sourceToken.isEmpty()) {
            this.startThread("logtail-warning-logger", () -> this.logger.warn("Missing Source token for Better Stack - disabling LogtailAppender. Find out how to fix this at: https://betterstack.com/docs/logs/java "));
            this.disabled = true;
            return;
        }
        if (this.batch.size() < this.maxQueueSize) {
            this.batch.add(event);
        }
        if (this.warnAboutMaxQueueSize && this.batch.size() == this.maxQueueSize) {
            this.warnAboutMaxQueueSize = false;
            this.startThread("logtail-error-logger", () -> this.logger.error("Maximum number of messages in queue reached ({}). New messages will be dropped.", (Object)this.maxQueueSize));
        }
        if (this.batch.size() >= this.batchSize) {
            if (this.isFlushing.get()) {
                return;
            }
            this.startThread("logtail-appender-flush", new LogtailSender());
        }
    }

    protected void startThread(String threadName, Runnable runnable) {
        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
        thread.setName(threadName);
        thread.start();
    }

    protected void flush() {
        if (this.batch.isEmpty()) {
            return;
        }
        if (this.isFlushing.getAndSet(true)) {
            return;
        }
        this.mustReflush = false;
        int flushedSize = this.batch.size();
        if (flushedSize > this.batchSize) {
            flushedSize = this.batchSize;
            this.mustReflush = true;
        }
        if (this.retries > 0 && flushedSize > this.retrySize) {
            flushedSize = this.retrySize;
            this.mustReflush = true;
        }
        if (!this.flushLogs(flushedSize)) {
            this.mustReflush = true;
        }
        this.isFlushing.set(false);
        if (this.mustReflush || this.batch.size() >= this.batchSize) {
            this.flush();
        }
    }

    protected boolean flushLogs(int flushedSize) {
        this.retrySize = flushedSize;
        try {
            LogtailResponse response;
            if (this.retries > this.maxRetries) {
                this.batch.subList(0, flushedSize).clear();
                this.logger.error("Dropped batch of {} logs.", (Object)flushedSize);
                this.warnAboutMaxQueueSize = true;
                this.retries = 0;
                return true;
            }
            if (this.retries > 0) {
                this.logger.info("Retrying to send {} logs to Better Stack ({} / {})", new Object[]{flushedSize, this.retries, this.maxRetries});
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retrySleepMilliseconds);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if ((response = this.callHttpURLConnection(flushedSize)).getStatus() >= 300 || response.getStatus() < 200) {
                this.logger.error("Error calling Better Stack : {} ({})", (Object)response.getError(), (Object)response.getStatus());
                ++this.retries;
                return false;
            }
            this.batch.subList(0, flushedSize).clear();
            this.warnAboutMaxQueueSize = true;
            this.retries = 0;
            return true;
        }
        catch (ConcurrentModificationException e) {
            this.logger.error("Error clearing {} logs from batch, will retry immediately.", (Object)flushedSize, (Object)e);
            this.retries = this.maxRetries;
        }
        catch (JsonProcessingException e) {
            this.logger.error("Error processing JSON data : {}", (Object)e.getMessage(), (Object)e);
            this.retries = this.maxRetries;
        }
        catch (Exception e) {
            this.logger.error("Error trying to call Better Stack : {}", (Object)e.getMessage(), (Object)e);
        }
        ++this.retries;
        return false;
    }

    protected LogtailResponse callHttpURLConnection(int flushedSize) throws IOException {
        HttpURLConnection connection = this.getHttpURLConnection();
        try {
            connection.connect();
        }
        catch (Exception e) {
            this.logger.error("Error trying to call Better Stack : {}", (Object)e.getMessage(), (Object)e);
        }
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = this.batchToJson(flushedSize).getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
            os.flush();
        }
        connection.disconnect();
        return new LogtailResponse(connection.getResponseMessage(), connection.getResponseCode());
    }

    protected HttpURLConnection getHttpURLConnection() throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(this.ingestUrl).openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setRequestProperty("User-Agent", this.userAgent);
        httpURLConnection.setRequestProperty("Accept", "application/json");
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setRequestProperty("Charset", "UTF-8");
        httpURLConnection.setRequestProperty("Authorization", String.format("Bearer %s", this.sourceToken));
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setConnectTimeout(this.connectTimeout);
        httpURLConnection.setReadTimeout(this.readTimeout);
        return httpURLConnection;
    }

    protected String batchToJson(int flushedSize) throws JsonProcessingException {
        return this.dataMapper.writeValueAsString(new ArrayList<ILoggingEvent>(this.batch.subList(0, flushedSize)).stream().map(this::buildPostData).collect(Collectors.toList()));
    }

    protected Map<String, Object> buildPostData(ILoggingEvent event) {
        HashMap<String, Object> logLine = new HashMap<String, Object>();
        logLine.put("dt", Long.toString(event.getTimeStamp()));
        logLine.put("level", event.getLevel().toString());
        logLine.put("app", this.appName);
        logLine.put("message", this.generateLogMessage(event));
        logLine.put("meta", this.generateLogMeta(event));
        logLine.put("runtime", this.generateLogRuntime(event));
        logLine.put("args", event.getArgumentArray());
        if (event.getThrowableProxy() != null) {
            logLine.put("throwable", this.generateLogThrowable(event.getThrowableProxy()));
        }
        return logLine;
    }

    protected String generateLogMessage(ILoggingEvent event) {
        return this.encoder != null ? new String(this.encoder.encode((Object)event)) : event.getFormattedMessage();
    }

    protected Map<String, Object> generateLogMeta(ILoggingEvent event) {
        HashMap<String, Object> logMeta = new HashMap<String, Object>();
        logMeta.put("logger", event.getLoggerName());
        if (!this.mdcFields.isEmpty() && !event.getMDCPropertyMap().isEmpty()) {
            for (Map.Entry entry : event.getMDCPropertyMap().entrySet()) {
                if (!this.mdcFields.contains(entry.getKey())) continue;
                String type = this.mdcTypes.get(this.mdcFields.indexOf(entry.getKey()));
                logMeta.put((String)entry.getKey(), this.getMetaValue(type, (String)entry.getValue()));
            }
        }
        return logMeta;
    }

    protected Map<String, Object> generateLogRuntime(ILoggingEvent event) {
        StackTraceElement[] callerData;
        HashMap<String, Object> logRuntime = new HashMap<String, Object>();
        logRuntime.put("thread", event.getThreadName());
        if (event.hasCallerData() && (callerData = event.getCallerData()).length > 0) {
            StackTraceElement callerContext = callerData[0];
            logRuntime.put("class", callerContext.getClassName());
            logRuntime.put("method", callerContext.getMethodName());
            logRuntime.put("file", callerContext.getFileName());
            logRuntime.put("line", callerContext.getLineNumber());
        }
        return logRuntime;
    }

    protected Map<String, Object> generateLogThrowable(IThrowableProxy throwable) {
        HashMap<String, Object> logThrowable = new HashMap<String, Object>();
        logThrowable.put("message", throwable.getMessage());
        logThrowable.put("class", throwable.getClassName());
        logThrowable.put("stackTrace", throwable.getStackTraceElementProxyArray());
        if (throwable.getCause() != null) {
            logThrowable.put("cause", this.generateLogThrowable(throwable.getCause()));
        }
        return logThrowable;
    }

    protected Object getMetaValue(String type, String value) {
        try {
            switch (type) {
                case "int": {
                    return Integer.valueOf(value);
                }
                case "long": {
                    return Long.valueOf(value);
                }
                case "boolean": {
                    return Boolean.valueOf(value);
                }
            }
        }
        catch (NumberFormatException e) {
            this.logger.error("Error getting meta value - {}", (Object)e.getMessage(), (Object)e);
        }
        return value;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setIngestUrl(String ingestUrl) {
        this.ingestUrl = ingestUrl;
    }

    public void setSourceToken(String sourceToken) {
        this.sourceToken = sourceToken;
    }

    public void setIngestKey(String ingestKey) {
        if (this.sourceToken == null) {
            return;
        }
        this.sourceToken = ingestKey;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setMdcFields(String mdcFields) {
        this.mdcFields = Arrays.asList(mdcFields.split(","));
    }

    public void setMdcTypes(String mdcTypes) {
        this.mdcTypes = Arrays.asList(mdcTypes.split(","));
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchInterval(int batchInterval) {
        this.scheduledFuture.cancel(false);
        this.scheduledFuture = this.scheduledExecutorService.scheduleWithFixedDelay(new LogtailSender(), batchInterval, batchInterval, TimeUnit.MILLISECONDS);
        this.batchInterval = batchInterval;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setRetrySleepMilliseconds(int retrySleepMilliseconds) {
        this.retrySleepMilliseconds = retrySleepMilliseconds;
    }

    public void setObjectMapperModule(String className) {
        try {
            Module module = (Module)Class.forName(className).newInstance();
            this.dataMapper.registerModule(module);
            this.logger.info("Module '{}' successfully registered in ObjectMapper.", (Object)className);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.logger.error("Module '{}' couldn't be registered in ObjectMapper : ", (Object)className, (Object)e);
        }
    }

    public void setEncoder(PatternLayoutEncoder encoder) {
        this.encoder = encoder;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void stop() {
        this.scheduledExecutorService.shutdown();
        this.mustReflush = true;
        this.flush();
        super.stop();
    }

    public class LogtailSender
    implements Runnable {
        @Override
        public void run() {
            block2: {
                try {
                    LogtailAppender.this.flush();
                }
                catch (Exception e) {
                    LogtailAppender.this.logger.error("Error trying to flush : {}", (Object)e.getMessage(), (Object)e);
                    if (!LogtailAppender.this.isFlushing.get()) break block2;
                    LogtailAppender.this.isFlushing.set(false);
                }
            }
        }
    }
}

