/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.longmaosoft.sdk.core;

import com.longmaosoft.sdk.core.auth.LongMaoCredentials;
import com.longmaosoft.sdk.core.exception.ClientException;

import java.io.IOException;

public class DefaultLongMaoClient implements LongMaoClient {

    private static final String LONGMAO_DOMAIN = "https://api.service.longmaosoft.com/gateway.do";
    private LongMaoCredentials credentials;
    private String domain;

    public DefaultLongMaoClient(LongMaoCredentials credentials) {
        this(LONGMAO_DOMAIN, credentials);
    }

    public DefaultLongMaoClient(String domain, LongMaoCredentials credentials) {
        this.domain = domain;
        this.credentials = credentials;
    }

    @Override
    public <T extends LongMaoResponse> T request(LongMaoRequest<T> request) {
        try {
            return request.request(domain, this.credentials);
        } catch (IOException e) {
            throw new ClientException("500", e.getMessage(), e);
        }
    }

}
