package com.longmaosoft.sdk.core.auth;

import com.longmaosoft.sdk.core.exception.ClientException;

import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Signer {

    public static String sign(Map<String,String> params, String key) throws ClientException {
        try{
            String[] keys = params.keySet().toArray(new String[0]);
            Arrays.sort(keys);

            StringBuilder query = new StringBuilder();
            for (String name : keys) {
                query.append("&").append(name).append("=").append(params.get(name));
            }
            if(query.length() > 0) {
                return md5(query.substring(1) + key).toUpperCase();
            }
        }catch (Exception e) {
            throw new ClientException("400", e.getMessage(), e);
        }
        return "";
    }

    private static String md5(String src) throws Exception {
        // Create MD5 Hash
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.update(src.getBytes());
        byte messageDigest[] = digest.digest();

        // Create Hex String
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < messageDigest.length; i++) {
            String h = Integer.toHexString(0xFF & messageDigest[i]);
            while (h.length() < 2) {
                h = "0" + h;
            }
            hexString.append(h);
        }
        return hexString.toString();
    }

}
