package com.longmaosoft.sdk.core.utils;

import com.longmaosoft.sdk.core.exception.ClientException;
import org.apache.http.Consts;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import java.io.IOException;

public class HttpRequestUtils {

    public static String get(String url) throws IOException {
        return get(url, 5000);
    }

    public static String get(String url, int timeout) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try{
            ///////////////////////////////////////////////////////////////////////////
            // 构建请求对象
            ///////////////////////////////////////////////////////////////////////////
            RequestBuilder requestBuilder = RequestBuilder.get(url);
            //设置请求编码
            requestBuilder.setCharset(Consts.UTF_8);
            ///////////////////////////////////////////////////////////////////////////
            // 设置请求超时时间
            ///////////////////////////////////////////////////////////////////////////
            RequestConfig requestConfig = RequestConfig.custom()
                    .setSocketTimeout(timeout)
                    .setConnectTimeout(timeout)
                    .build();
            requestBuilder.setConfig(requestConfig);
            ///////////////////////////////////////////////////////////////////////////
            // 获取请求结果
            ///////////////////////////////////////////////////////////////////////////
            CloseableHttpResponse response = httpClient.execute(requestBuilder.build());
            StatusLine statusLine = response.getStatusLine();
            if(statusLine.getStatusCode() != 200) {
                throw new ClientException(String.valueOf(statusLine.getStatusCode()), statusLine.getReasonPhrase(), null);
            }

            try{
                return EntityUtils.toString(response.getEntity(), "UTF-8");
            }finally {
                response.close();
            }
        }finally {
            httpClient.close();
        }
    }

}
