package com.longmaosoft.sdk.tags.model;

import com.alibaba.fastjson.JSONObject;
import com.longmaosoft.sdk.core.LongMaoRequest;
import com.longmaosoft.sdk.core.exception.ClientException;
import com.longmaosoft.sdk.core.utils.StringUtils;

public class TagsTencentPushRequest extends LongMaoRequest<TagsTencentPushResponse> {

    private String taskId;
    private String taskType;
    private String title;
    private String taskLevel;
    private String filePath;

    public TagsTencentPushRequest() {
        super("longmao.tags.tencent.push", "2022-11-15");
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskType() {
        return taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTaskLevel() {
        return taskLevel;
    }

    public void setTaskLevel(String taskLevel) {
        this.taskLevel = taskLevel;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    protected Boolean isSign() {
        return true;
    }

    @Override
    protected void putRequestParams() {
        if(StringUtils.isEmpty(title)) {
            throw new ClientException("400", "title - 任务备注不能为空", null);
        }
        if(StringUtils.isEmpty(taskId)) {
            throw new ClientException("400", "taskId - 标注任务ID不能为空", null);
        }
        if(StringUtils.isEmpty(taskType)) {
            throw new ClientException("400", "taskType - 任务类型不能为空", null);
        }
        if(StringUtils.isEmpty(filePath)) {
            throw new ClientException("400", "filePath - 文件路径不能为空", null);
        }
        if(StringUtils.isEmpty(taskLevel)) {
            throw new ClientException("400", "taskLevel - 任务类型不能为空", null);
        }
        this.putPostParameter("task_id", taskId);
        this.putPostParameter("task_type", taskType);
        this.putPostParameter("task_level", taskLevel);
        this.putPostParameter("title", title);
        this.putPostParameter("file_path", filePath);
    }

    @Override
    protected TagsTencentPushResponse parserResponseData(JSONObject data) {
        TagsTencentPushResponse response = new TagsTencentPushResponse();
        response.setCode(data.getString("code"));
        response.setMessage(data.getString("message"));
        return response;
    }

}
