package com.longmaosoft.sdk.tags.model;

import com.alibaba.fastjson.JSONObject;
import com.longmaosoft.sdk.core.LongMaoRequest;
import com.longmaosoft.sdk.core.exception.ClientException;
import com.longmaosoft.sdk.core.utils.StringUtils;

public class TagsUploadDataCsvRequest extends LongMaoRequest<TagsUploadDataCsvResponse> {

    private String title;
    private String url;

    public TagsUploadDataCsvRequest() {
        super("longmao.tags.upload", "2022-09-03");
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    protected Boolean isSign() {
        return true;
    }

    @Override
    protected void putRequestParams() {
        if(StringUtils.isEmpty(title)) {
            throw new ClientException("400", "title - CSV文件描述不能为空", null);
        }
        if(StringUtils.isEmpty(url)) {
            throw new ClientException("400", "url - CSV链接不能为空", null);
        }
        this.putPostParameter("title", title);
        this.putPostParameter("url", url);
    }

    @Override
    protected TagsUploadDataCsvResponse parserResponseData(JSONObject data) {
        TagsUploadDataCsvResponse response = new TagsUploadDataCsvResponse();
        response.setCode(data.getString("code"));
        response.setMessage(data.getString("message"));
        return response;
    }

}
