/*
 * Decompiled with CFR 0.152.
 */
package com.longmaosoft.sdk.core;

import com.alibaba.fastjson.JSONObject;
import com.longmaosoft.sdk.core.LongMaoResponse;
import com.longmaosoft.sdk.core.auth.LongMaoCredentials;
import com.longmaosoft.sdk.core.auth.Signer;
import com.longmaosoft.sdk.core.exception.ClientException;
import com.longmaosoft.sdk.core.exception.ServerException;
import com.longmaosoft.sdk.core.http.HttpRequest;
import com.longmaosoft.sdk.core.utils.ParameterUtils;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public abstract class LongMaoRequest<T extends LongMaoResponse>
extends HttpRequest {
    private final Map<String, String> queryParameters = new HashMap<String, String>();
    private final Map<String, Object> postParameters = new HashMap<String, Object>();
    private File file;

    public LongMaoRequest(String method, String version) {
        this.queryParameters.put("method", method);
        this.queryParameters.put("version", version);
        this.queryParameters.put("timestamp", ParameterUtils.getTime());
        this.queryParameters.put("format", "JSON");
    }

    protected T request(String domain, LongMaoCredentials credentials) throws IOException {
        HashMap<String, String> imutableMap = new HashMap<String, String>(this.queryParameters);
        imutableMap.put("access_key_id", credentials.getAccessKeyId());
        if (this.isSign().booleanValue()) {
            imutableMap.put("sign", Signer.sign(imutableMap, credentials.getAccessKeySecret()));
        }
        StringBuilder queryParams = new StringBuilder();
        for (Map.Entry entry : imutableMap.entrySet()) {
            queryParams.append("&").append((String)entry.getKey()).append("=").append(URLEncoder.encode((String)entry.getValue(), "UTF-8"));
        }
        String api = domain + "?" + queryParams.substring(1);
        this.putRequestParams();
        String str = null;
        str = this.file != null ? this.request(api, this.postParameters, this.file) : this.request(api, JSONObject.toJSONString(this.postParameters));
        JSONObject data = JSONObject.parseObject((String)str);
        String code = data.getString("code");
        if (!"200".equals(code)) {
            if (code.equals("500")) {
                throw new ServerException(code, data.getString("message"), null);
            }
            throw new ClientException(code, data.getString("message"), null);
        }
        return this.parserResponseData(data);
    }

    protected void putPostParameter(String name, Object value) {
        if (value.getClass().isAssignableFrom(File.class)) {
            this.file = (File)value;
        } else {
            this.postParameters.put(name, value);
        }
    }

    protected abstract Boolean isSign();

    protected abstract void putRequestParams();

    protected abstract T parserResponseData(JSONObject var1);
}

