/*
 * Decompiled with CFR 0.152.
 */
package com.longmaosoft.sdk.core.http;

import com.longmaosoft.sdk.core.exception.ClientException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HttpRequest {
    protected Map<String, String> headers = new HashMap<String, String>();
    protected Integer connectTimeout = 10000;
    protected Integer readTimeout = 10000;

    protected void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    protected void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    protected void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String request(String api, String json) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String string;
            CloseableHttpResponse response;
            StatusLine statusLine;
            RequestBuilder requestBuilder = RequestBuilder.post((String)api);
            requestBuilder.setCharset(Consts.UTF_8);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.readTimeout.intValue()).setConnectTimeout(this.connectTimeout.intValue()).build();
            requestBuilder.setConfig(requestConfig);
            ContentType contentType = ContentType.create((String)"application/json", (String)"UTF-8");
            StringEntity entity = new StringEntity(json, contentType);
            requestBuilder.setEntity((HttpEntity)entity);
            if (this.headers != null) {
                for (Map.Entry<String, String> item : this.headers.entrySet()) {
                    requestBuilder.addHeader(item.getKey(), item.getValue());
                }
            }
            if ((statusLine = (response = httpClient.execute(requestBuilder.build())).getStatusLine()).getStatusCode() != 200) {
                throw new ClientException(String.valueOf(statusLine.getStatusCode()), statusLine.getReasonPhrase(), null);
            }
            try {
                string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
            catch (Throwable throwable) {
                response.close();
                throw throwable;
            }
            response.close();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String request(String api, Map<String, Object> params, File file) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String string;
            RequestBuilder requestBuilder = RequestBuilder.post((String)api);
            requestBuilder.setCharset(Consts.UTF_8);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.readTimeout.intValue()).setConnectTimeout(this.connectTimeout.intValue()).build();
            requestBuilder.setConfig(requestConfig);
            if (this.headers != null) {
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    requestBuilder.addHeader(entry.getKey(), entry.getValue());
                }
            }
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setCharset(Consts.UTF_8).setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("file", file);
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                builder.addTextBody(entry.getKey(), entry.getValue().toString());
            }
            requestBuilder.setEntity(builder.build());
            CloseableHttpResponse closeableHttpResponse = httpClient.execute(requestBuilder.build());
            StatusLine statusLine = closeableHttpResponse.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                throw new ClientException(String.valueOf(statusLine.getStatusCode()), statusLine.getReasonPhrase(), null);
            }
            try {
                string = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)"UTF-8");
            }
            catch (Throwable throwable) {
                closeableHttpResponse.close();
                throw throwable;
            }
            closeableHttpResponse.close();
            return string;
        }
    }
}

