/*
 * Decompiled with CFR 0.152.
 */
package com.longmaosoft.sdk.core.utils;

import com.longmaosoft.sdk.core.exception.ClientException;
import java.io.IOException;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HttpRequestUtils {
    public static String get(String url) throws IOException {
        return HttpRequestUtils.get(url, 5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, int timeout) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String string;
            RequestBuilder requestBuilder = RequestBuilder.get((String)url);
            requestBuilder.setCharset(Consts.UTF_8);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).build();
            requestBuilder.setConfig(requestConfig);
            CloseableHttpResponse response = httpClient.execute(requestBuilder.build());
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                throw new ClientException(String.valueOf(statusLine.getStatusCode()), statusLine.getReasonPhrase(), null);
            }
            try {
                string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
            catch (Throwable throwable) {
                response.close();
                throw throwable;
            }
            response.close();
            return string;
        }
    }
}

