package com.laputapp.api;

import com.laputapp.Laputapp;

import retrofit.RequestInterceptor;

public class ApiHeaders implements RequestInterceptor {

    private static final String mVersion = Laputapp.getAppInfo().version;
    private static final String mVersionCode = Laputapp.getAppInfo().versionCode;
    private static final String mDeviceId = Laputapp.getAppInfo().deviceId;
    private static final String mChannelId = Laputapp.getAppInfo().channel;

    @Override
    public void intercept(RequestFacade request) {
        request.addHeader("version-code", mVersionCode);
        request.addHeader("version-name", mVersion);
        request.addHeader("device-id", mDeviceId);
        request.addHeader("channel-id", mChannelId);
        request.addHeader("platform", "android");
    }

}
