package com.laputapp.api;

import android.app.Application;

import com.laputapp.BuildConfig;
import com.laputapp.Laputapp;
import com.laputapp.R;
import com.squareup.okhttp.Cache;
import com.squareup.okhttp.OkHttpClient;

import java.io.File;
import java.util.MissingResourceException;

import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;

public class ApiService {

  public static final String API_URL = Laputapp.getAppResources().getString(R.string.api_url);

  private static ApiService sInstance;

  private boolean isDebug;
  private RestAdapter restAdapter;
  private ApiHeaders mApiHeaders;

  public static synchronized ApiService getInstance() {
    if (sInstance == null) {
      sInstance = new ApiService();
      sInstance.setIsDebug(BuildConfig.DEBUG);
    }
    return sInstance;
  }

  public ApiService setIsDebug(boolean isDebug) {
    this.isDebug = isDebug;
    if (restAdapter != null) {
      restAdapter.setLogLevel(isDebug ? RestAdapter.LogLevel.FULL : RestAdapter.LogLevel.NONE);
    }
    return this;
  }

  private ApiHeaders getApiHeaders() {
    if (mApiHeaders == null) {
      mApiHeaders = new ApiHeaders();
    }

    return mApiHeaders;
  }

  private Client getClient() {
    return new OkClient(createOkHttpClient(Laputapp.getInstance()));
  }

  static final int DISK_CACHE_SIZE = 50 * 1024 * 1024; // 50MB

  static OkHttpClient createOkHttpClient(Application app) {
    OkHttpClient client = new OkHttpClient();

    // Install an HTTP cache in the application cache directory.
    File cacheDir = new File(app.getCacheDir(), "http");
    Cache cache = new Cache(cacheDir, DISK_CACHE_SIZE);
    client.setCache(cache);

    return client;
  }

  protected RestAdapter.Builder newRestAdapterBuilder() {
    return new RestAdapter.Builder();
  }

  protected RestAdapter getRestAdapter() {
    if (restAdapter == null) {
      try {
        RestAdapter.Builder builder = newRestAdapterBuilder();
        builder.setClient(getClient());
        builder.setEndpoint(API_URL);
        builder.setRequestInterceptor(getApiHeaders());
        if (isDebug) {
          builder.setLogLevel(RestAdapter.LogLevel.FULL);
        }
        restAdapter = builder.build();
      } catch (NullPointerException e) {
        throw new MissingResourceException("Define your endpoint in api_url string resource.", getClass().getName(), "api_url");
      }
    }

    return restAdapter;
  }

  public static <T> T create(Class<T> service) {
    return getInstance().getRestAdapter().create(service);
  }
}
