/**
 * Created by YuGang Yang on April 29, 2015.
 * Copyright 2007-2015 Laputapp.com. All rights reserved.
 */
package com.laputapp.ui;

import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewStub;

import com.laputapp.R;
import com.laputapp.utilities.UiUtilities;

import java.lang.ref.WeakReference;

public abstract class PagedRecyclerPullActivity<T> extends RecyclerPullBaseActivity<T> {

  private WeakScrollListener scrollListener;
  ViewStub mLoadMore;
  private View mLoadMoreView;

  private boolean hasWarned = false;

  @Override
  public void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    mLoadMore = UiUtilities.getView(this, R.id.view_load_more);
  }

  @Override
  protected void onPostCreate(Bundle savedInstanceState) {
    super.onPostCreate(savedInstanceState);

    final RecyclerView recyclerView = getRecyclerView();
    scrollListener = new WeakScrollListener(
            (LinearLayoutManager) recyclerView.getLayoutManager(), this);
    recyclerView.setOnScrollListener(scrollListener);
    recyclerView.addOnScrollListener(scrollListener);

    // set load more view
    mLoadMore.setLayoutResource(R.layout.view_load_more);
    mLoadMoreView = mLoadMore.inflate();
    hideMoreProgress();
  }

  @Override
  protected void onStop() {
    super.onStop();

    final RecyclerView recyclerView = getRecyclerView();
    if (recyclerView != null && scrollListener != null) {
      recyclerView.removeOnScrollListener(scrollListener);
    }
  }

  public void showMoreProgress() {
    mLoadMore.setVisibility(View.VISIBLE);
  }

  public void hideMoreProgress() {
    mLoadMore.setVisibility(View.GONE);
  }

  @Override public void onFinish() {
    super.onFinish();
    if (getDataLoader().isLoadMore()) {
      hideMoreProgress();
    }
  }

  @Override protected void updateRecyclerView() {
    super.updateRecyclerView();
    hasWarned = false;
  }

  private static class WeakScrollListener extends RecyclerView.OnScrollListener {

    // The minimum amount of items to have below your current scroll position before loading more.
    private static final int VISIBLE_THRESHOLD = 1;

    private final WeakReference<PagedRecyclerPullActivity> mTarget;
    private final LinearLayoutManager mLayoutManager;

    public WeakScrollListener(LinearLayoutManager layoutManager,
        PagedRecyclerPullActivity target) {
      mLayoutManager = layoutManager;
      mTarget = new WeakReference<>(target);
    }

    @Override public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
      super.onScrolled(recyclerView, dx, dy);

      final LinearLayoutManager layoutManager = mLayoutManager;

      final int visibleItemCount = recyclerView.getChildCount();
      final int totalItemCount = layoutManager.getItemCount();
      final int firstVisibleItemPosition = layoutManager.findFirstVisibleItemPosition();
      //final int lastVisibleItemPosition = layoutManager.findLastVisibleItemPosition();

      final PagedRecyclerPullActivity target = mTarget.get();
      if (target == null) return;

      if (target.isFinishing()
          || target.hasWarned
          || !target.getDataLoader().canLoadMore()
          || totalItemCount == 0
          ) {
        return;
      }

      if (totalItemCount - visibleItemCount <= (firstVisibleItemPosition + VISIBLE_THRESHOLD)
          && totalItemCount < target.getDataLoader().getTotalSize() ) {
        // End has been reached
        // Do something
        onLoadMore();
      }

    }

    private void onLoadMore() {
      final PagedRecyclerPullActivity target = mTarget.get();
      if (target != null && target.getDataLoader() != null && target.getDataLoader().canLoadMore()) {
        target.showMoreProgress();
        target.hasWarned = true;
        target.getDataLoader().loadMore();
      }
    }

  }

}
