/**
 * Created by YuGang Yang on April 29, 2015.
 * Copyright 2007-2015 Laputapp.com. All rights reserved.
 */
package com.laputapp.ui;

import android.os.Bundle;
import android.support.v4.widget.TextViewCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.ViewSwitcher;
import com.laputapp.R;
import com.laputapp.http.Callbacks;
import com.laputapp.http.DataLoader;
import com.laputapp.http.Response;
import com.laputapp.ptr.PtrBaseFrameLayout;
import com.laputapp.ui.adapter.RecyclerAdapter;
import com.laputapp.utilities.Lists;
import com.laputapp.utilities.UiUtilities;
import java.util.ArrayList;
import in.srain.cube.views.ptr.PtrDefaultHandler;
import in.srain.cube.views.ptr.PtrFrameLayout;
import in.srain.cube.views.ptr.PtrHandler;
import retrofit.RetrofitError;

public abstract class RecyclerPullRefreshFragment<T>  extends BaseFragment implements
    DataLoader.Loader<T>,
    DataLoader.KeyExtractor<T>,
    Callbacks.RequestCallback<ArrayList<T>>, PtrHandler {

  private static final long DEFAULT_PAGE = 1;
  private static final long DEFAULT_PAGE_SIZE = 10;

  ViewSwitcher mSwitcherLoading;
  ViewSwitcher mSwitcherContent;
  RecyclerView mRecyclerView;
  PtrBaseFrameLayout mPullRefreshLayout;

  TextView mEmptyView;
  LinearLayout mBtnContainerView;

  private RecyclerAdapter<T> mAdapter;

  private boolean mDataHasLoaded = false;

  protected ArrayList<T> mItems = Lists.newArrayList();
  private DataLoader<T> mDataLoader;

  protected abstract RecyclerAdapter<T> createRecyclerViewAdapter();

  protected long createDefaultPage() {
    return DEFAULT_PAGE;
  }

  protected long createDefaultPageSize() {
    return DEFAULT_PAGE_SIZE;
  }

  protected int[] getColorSchemeResources() {
    return null;
  }


  @Override public void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    mAdapter = createRecyclerViewAdapter();
    mDataLoader = new DataLoader<>(this, this, createDefaultPage(), createDefaultPageSize());
    mDataLoader.addRequestCallback(this);
  }

  @Override public View onCreateView(LayoutInflater inflater, ViewGroup container,
      Bundle savedInstanceState) {
    return inflater.inflate(R.layout.fragment_pull_refresh_recycler_view, container, false);
  }

  @Override public void onViewCreated(View view, Bundle savedInstanceState) {
    super.onViewCreated(view, savedInstanceState);
    mEmptyView = UiUtilities.getView(view, android.R.id.empty);
    mSwitcherLoading = UiUtilities.getView(view, R.id.view_loading_switcher);
    mSwitcherContent = UiUtilities.getView(view, R.id.view_content_switcher);
    mRecyclerView = UiUtilities.getView(view, R.id.recycler_view);
    mPullRefreshLayout = UiUtilities.getView(view, R.id.pull_refresh_layout);
    mBtnContainerView = UiUtilities.getView(view, R.id.view_btns);
    setupRefreshLayout();
    setupRecyclerView();
  }

  @Override public void onActivityCreated(Bundle savedInstanceState) {
    super.onActivityCreated(savedInstanceState);

    if (!mItems.isEmpty()) {
      updateRecyclerView();
    }

    if (!mDataHasLoaded) {
      mDataLoader.refresh();
    }
  }

  public void setupRefreshLayout() {
    mPullRefreshLayout.setLastUpdateTimeRelateObject(this);
    mPullRefreshLayout.setPtrHandler(this);
    mPullRefreshLayout.setResistance(1.7f);
    mPullRefreshLayout.setRatioOfHeaderHeightToRefresh(1.2f);
    mPullRefreshLayout.setDurationToClose(200);
    mPullRefreshLayout.setDurationToCloseHeader(1000);
    mPullRefreshLayout.setPullToRefresh(false);
    mPullRefreshLayout.setKeepHeaderWhenRefresh(true);
    setHeader();
  }

  private void setHeader() {
    getRefreshLayout().setCustomHeaderView(setHeaderView());
  }

  public View setHeaderView() {
    return mPullRefreshLayout.getHeader();
  }

  private void setupRecyclerView() {
    mRecyclerView.setHasFixedSize(true);
    mRecyclerView.setAdapter(mAdapter);
    mRecyclerView.setLayoutManager(new LinearLayoutManager(getActivity()));
  }

  @Override public void onDestroy() {
    super.onDestroy();
    mDataLoader.removeRequestCallback();
    mDataLoader = null;
    mAdapter = null;
  }

  protected void startRefreshing() {
    if (!isVisible()) return;
    mPullRefreshLayout.autoRefresh();
  }

  protected void stopRefreshing() {
    if (!isVisible()) return;
    mPullRefreshLayout.refreshComplete();
  }

  protected RecyclerPullRefreshFragment showLoadingView() {
    if (!isVisible()) return this;
    if (mSwitcherLoading.getCurrentView().getId() == R.id.view_content_switcher) {
      mSwitcherLoading.showPrevious();
    }
    return this;
  }

  protected RecyclerPullRefreshFragment showContentView() {
    if (!isVisible()) return this;
    if (mSwitcherLoading.getCurrentView().getId() == R.id.view_loading) {
      mSwitcherLoading.showNext();
    }
    if (mSwitcherContent.getCurrentView().getId() != R.id.view_recycler) {
      mSwitcherContent.showPrevious();
    }
    return this;
  }

  protected RecyclerPullRefreshFragment showEmptyView() {
    if (!isVisible()) return this;
    if (mSwitcherLoading.getCurrentView().getId() == R.id.view_loading) {
      mSwitcherLoading.showNext();
    }
    if (mSwitcherContent.getCurrentView().getId() == R.id.view_recycler) {
      mSwitcherContent.showNext();
    }
    return this;
  }

  protected void updateRecyclerView() {
    if (!isVisible()) return;

    mAdapter.updateData(mItems);
    if (mItems.isEmpty()) {
      showEmptyView();
    } else {
      showContentView();
    }
  }

  public DataLoader<T> getDataLoader() {
    return mDataLoader;
  }

  public PtrBaseFrameLayout getRefreshLayout() {
    return mPullRefreshLayout;
  }

  public RecyclerView getRecyclerView() {
    return mRecyclerView;
  }

  @Override public void beforeRefresh() {
  }

  @Override public void beforeLoadMore() {
  }

  @Override public T register(T resource) {
    return resource;
  }

  @Override public void onRequestComplete(Response<ArrayList<T>> response) {
    mItems = mDataLoader.getResources();
    mDataHasLoaded = !mItems.isEmpty();
  }

  @Override public void onRequestFailure(Response<ArrayList<T>> response) {
    mDataHasLoaded = false;
  }

  @Override public void onRequestFailure(RetrofitError error) {
    mDataHasLoaded = false;
  }

  @Override public void onRequestNetworkError() {
    mDataHasLoaded = false;
  }

  @Override public void onFinish() {
    stopRefreshing();
    updateRecyclerView();
  }

  @Override public boolean canCache() {
    return false;
  }

  @Override public void handleLocalCache(ArrayList<T> data) {

  }

  @Override public void onCacheLoaded(ArrayList<T> localData) {
    if (localData == null || localData.isEmpty()) return;
    for (T data : localData) {
      register(data);
    }
    mItems.addAll(localData);
    if (!mItems.isEmpty()) {
      updateRecyclerView();
    }
  }

  public ArrayList<T> getItems() {
    return mItems;
  }

  public RecyclerPullRefreshFragment setEmptyText(int resId) {
    setEmptyText(getString(resId));
    return this;
  }

  public RecyclerPullRefreshFragment setEmptyText(String empty) {
    mEmptyView.setText(empty);
    return this;
  }

  public RecyclerPullRefreshFragment setEmptyTextColor(int color) {
    mEmptyView.setTextColor(color);
    return this;
  }

  public RecyclerPullRefreshFragment setEmptyDrawablePadding(int pad) {
    mEmptyView.setCompoundDrawablePadding(pad);
    return this;
  }

  public RecyclerPullRefreshFragment setEmptyTopDrawable(int top) {
    return setEmptyTopDrawable(0, top, 0, 0);
  }

  public RecyclerPullRefreshFragment setEmptyTopDrawable(
      int start, int top, int end, int bottom) {
    TextViewCompat.setCompoundDrawablesRelativeWithIntrinsicBounds(mEmptyView, start, top, end, bottom);
    return this;
  }

  public LinearLayout getBtnContainerView() {
    return mBtnContainerView;
  }

  @Override
  public boolean checkCanDoRefresh(PtrFrameLayout ptrFrameLayout, View view, View view1) {
    return PtrDefaultHandler.checkContentCanBePulledDown(ptrFrameLayout, view, view1);
  }

  @Override
  public void onRefreshBegin(PtrFrameLayout ptrFrameLayout) {
    mDataLoader.refresh();
  }
}
