package com.laputapp.ui.adapter;

import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;

public class BindingGeneralAdapter<T extends LayoutProvider> extends GeneralAdapter<T> {

    public BindingGeneralAdapter(@NonNull ViewGroup parent) {
        super(parent);
    }

    @Override
    public ViewHolder<T> onCreateViewHolder(View view) {
        return new ViewHolder<>(view);
    }

    @Override
    public int getItemLayoutResId(int position) {
        return getItem(position).getItemLayoutRes(position);
    }

    public static class ViewHolder<T extends LayoutProvider> extends GeneralAdapter.ViewHolder<T> {

        private ViewDataBinding mBinding;

        public ViewHolder(View itemView) {
            super(itemView);
            try {
                mBinding = DataBindingUtil.bind(itemView);
            } catch (IllegalArgumentException e) {
                // ignore
            }
        }

        public ViewDataBinding getBinding() {
            return mBinding;
        }

        @Override
        public void bind(T item, int position) {
            super.bind(item, position);
            if (mBinding != null) {
                mBinding.setVariable(item.getVariableId(), item);
            }
        }
    }
}
