package com.laputapp.ui.adapter;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public class BindingRecyclerAdapter<T extends LayoutProvider> extends RecyclerAdapter<T> {

    public BindingRecyclerAdapter(Context context) {
        super(context);
    }

    @Override
    public ViewHolder<T> onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder<>(LayoutInflater.from(parent.getContext())
                .inflate(viewType, parent, false));
    }

    @Override
    public int getItemViewType(int position) {
        return getItem(position).getItemLayoutRes(position);
    }

    public static class ViewHolder<T extends LayoutProvider> extends RecyclerAdapter.ViewHolder<T> {

        private ViewDataBinding mBinding;

        public ViewHolder(View itemView) {
            super(itemView);
            try {
                mBinding = DataBindingUtil.bind(itemView);
            } catch (IllegalArgumentException e) {
                // ignore
            }
        }

        public ViewDataBinding getBinding() {
            return mBinding;
        }

        @Override
        public void bind(T item, int position) {
            super.bind(item, position);
            if (mBinding != null) {
                mBinding.setVariable(item.getVariableId(), item);
            }
        }
    }
}
