/**
 * Created by YuGang Yang on April 29, 2015.
 * Copyright 2007-2015 Laputapp.com. All rights reserved.
 */
package com.laputapp.ui.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;

import java.util.ArrayList;

public abstract class RecyclerAdapter<T> extends RecyclerView.Adapter<RecyclerAdapter.ViewHolder<T>> {

  private final Context mContext;
  private final LayoutInflater mInflater;

  private ArrayList<T> mData;

  public RecyclerAdapter(Context context) {
    mContext = context;
    mInflater = LayoutInflater.from(context);
    mData = new ArrayList<>();
  }

  public void updateData(ArrayList<T> data) {
    setData(data);
    notifyDataSetChanged();
  }

  public void setData(ArrayList<T> data) {
    mData.clear();
    if (data != null) {
      mData.addAll(data);
    }
  }

  public LayoutInflater getLayoutInflater() {
    return mInflater;
  }

  public Context getContext() {
    return mContext;
  }

  @Override
  public void onBindViewHolder(ViewHolder<T> holder, int position) {
    holder.bind(getItem(position), position);
  }

  /**
   * Get the data item associated with the specified position in the data set.
   *
   * @param position Position of the item whose data we want within the adapter's
   * data set.
   * @return The data at the specified position.
   */
  public T getItem(int position) {
    return mData.get(position);
  }

  @Override public int getItemCount() {
    return mData == null ? 0 : mData.size();
  }

  public static class ViewHolder<T> extends RecyclerView.ViewHolder {

    public ViewHolder(View itemView) {
      super(itemView);
    }

    public Context getContext() {
      return itemView.getContext();
    }

    public void bind(T item, int position) {
      if (item instanceof PositionConsumer) {
        ((PositionConsumer) item).setPosition(position);
      }
    }
  }
}
