/**
 * Created by YuGang Yang on February 06, 2015.
 * Copyright 2007-2015 Laputapp.com. All rights reserved.
 */
package com.laputapp.utilities;

import android.app.Activity;
import android.content.Context;
import android.widget.Toast;
import com.laputapp.http.BaseHttpCallback;
import com.laputapp.http.Response;
import java.lang.ref.WeakReference;
import retrofit.RetrofitError;

public abstract class MessageHttpCallback<T> extends BaseHttpCallback<T> {

  private WeakReference<Activity> mActivityRef;

  private final boolean mShowSuccessMessage;

  public MessageHttpCallback(Activity activity) {
    this(activity, false);
  }

  public MessageHttpCallback(Activity activity, boolean showSuccessMessage) {
    mActivityRef = new WeakReference<>(activity);
    mShowSuccessMessage = showSuccessMessage;
  }

  public Activity getActivity() {
    if (mActivityRef.get() == null || mActivityRef.get().isFinishing()) return null;
    return mActivityRef.get();
  }

  @Override
  public void onRequestComplete(Response<T> response) {
    super.onRequestComplete(response);
    Context context = getActivity();
    if (context != null && mShowSuccessMessage) {
      Toast.makeText(context, response.mMsg, Toast.LENGTH_SHORT).show();
    }
  }

  @Override
  public void onRequestFailure(RetrofitError error) {
    super.onRequestFailure(error);
    Context context = getActivity();
    if (context != null) {
      Toast.makeText(context, error.getMessage(), Toast.LENGTH_SHORT).show();
    }
  }

  @Override
  public void onRequestNetworkError() {
    super.onRequestNetworkError();
    Context context = getActivity();
    if (context != null) {
      Toast.makeText(context, "当前网络不可用，请检查您的网络设置", Toast.LENGTH_SHORT).show();
    }
  }

  @Override
  public void onRequestFailure(Response<T> response) {
    super.onRequestFailure(response);
    Activity context = getActivity();
    if (response.mCode == 401) {
      showNotAuthenticDialog();
    } else if (context != null) {
      Toast.makeText(context, response.mMsg, Toast.LENGTH_SHORT).show();
    }
  }

  abstract void showNotAuthenticDialog();
}
