/**
 * Created by YuGang Yang on April 29, 2015.
 * Copyright 2007-2015 Laputapp.com. All rights reserved.
 */
package com.laputapp.widget;

import android.content.Context;
import android.support.v4.widget.SwipeRefreshLayout;
import android.util.AttributeSet;

public class DelegatedSwipeRefreshLayout extends SwipeRefreshLayout {

  private ViewDelegate delegate;

  public DelegatedSwipeRefreshLayout(Context context) {
    super(context);
  }

  public DelegatedSwipeRefreshLayout(Context context, AttributeSet attrs) {
    super(context, attrs);
  }

  public void setViewDelegate(ViewDelegate delegate) {
    this.delegate = delegate;
  }

  @Override
  public boolean canChildScrollUp() {
    if (delegate != null) {
      return delegate.canChildScrollUp();
    }
    return super.canChildScrollUp();
  }

}
