/*
 * Decompiled with CFR 0.152.
 */
package com.android.common.widget;

import android.content.Context;
import android.database.Cursor;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.util.ArrayList;

public abstract class CompositeCursorAdapter
extends BaseAdapter {
    private static final int INITIAL_CAPACITY = 2;
    private final Context mContext;
    private ArrayList<Partition> mPartitions;
    private int mCount = 0;
    private boolean mCacheValid = true;
    private boolean mNotificationsEnabled = true;
    private boolean mNotificationNeeded;

    public CompositeCursorAdapter(Context context) {
        this(context, 2);
    }

    public CompositeCursorAdapter(Context context, int initialCapacity) {
        this.mContext = context;
        this.mPartitions = new ArrayList();
    }

    public Context getContext() {
        return this.mContext;
    }

    public void addPartition(boolean showIfEmpty, boolean hasHeader) {
        this.addPartition(new Partition(showIfEmpty, hasHeader));
    }

    public void addPartition(Partition partition) {
        this.mPartitions.add(partition);
        this.invalidate();
        this.notifyDataSetChanged();
    }

    public void addPartition(int location, Partition partition) {
        this.mPartitions.add(location, partition);
        this.invalidate();
        this.notifyDataSetChanged();
    }

    public void removePartition(int partitionIndex) {
        Cursor cursor = this.mPartitions.get((int)partitionIndex).cursor;
        if (cursor != null && !cursor.isClosed()) {
            cursor.close();
        }
        this.mPartitions.remove(partitionIndex);
        this.invalidate();
        this.notifyDataSetChanged();
    }

    public void clearPartitions() {
        for (Partition partition : this.mPartitions) {
            partition.cursor = null;
        }
        this.invalidate();
        this.notifyDataSetChanged();
    }

    public void close() {
        for (Partition partition : this.mPartitions) {
            Cursor cursor = partition.cursor;
            if (cursor == null || cursor.isClosed()) continue;
            cursor.close();
        }
        this.mPartitions.clear();
        this.invalidate();
        this.notifyDataSetChanged();
    }

    public void setHasHeader(int partitionIndex, boolean flag) {
        this.mPartitions.get((int)partitionIndex).hasHeader = flag;
        this.invalidate();
    }

    public void setShowIfEmpty(int partitionIndex, boolean flag) {
        this.mPartitions.get((int)partitionIndex).showIfEmpty = flag;
        this.invalidate();
    }

    public Partition getPartition(int partitionIndex) {
        return this.mPartitions.get(partitionIndex);
    }

    protected void invalidate() {
        this.mCacheValid = false;
    }

    public int getPartitionCount() {
        return this.mPartitions.size();
    }

    protected void ensureCacheValid() {
        if (this.mCacheValid) {
            return;
        }
        this.mCount = 0;
        for (Partition partition : this.mPartitions) {
            int count;
            Cursor cursor = partition.cursor;
            int n = count = cursor != null ? cursor.getCount() : 0;
            if (!partition.hasHeader || count != 0 || partition.showIfEmpty) {
                // empty if block
            }
            partition.count = ++count;
            this.mCount += count;
        }
        this.mCacheValid = true;
    }

    public boolean hasHeader(int partition) {
        return this.mPartitions.get((int)partition).hasHeader;
    }

    public int getCount() {
        this.ensureCacheValid();
        return this.mCount;
    }

    public Cursor getCursor(int partition) {
        return this.mPartitions.get((int)partition).cursor;
    }

    public void changeCursor(int partition, Cursor cursor) {
        Cursor prevCursor = this.mPartitions.get((int)partition).cursor;
        if (prevCursor != cursor) {
            if (prevCursor != null && !prevCursor.isClosed()) {
                prevCursor.close();
            }
            this.mPartitions.get((int)partition).cursor = cursor;
            if (cursor != null) {
                this.mPartitions.get((int)partition).idColumnIndex = cursor.getColumnIndex("_id");
            }
            this.invalidate();
            this.notifyDataSetChanged();
        }
    }

    public boolean isPartitionEmpty(int partition) {
        Cursor cursor = this.mPartitions.get((int)partition).cursor;
        return cursor == null || cursor.getCount() == 0;
    }

    public int getPartitionForPosition(int position) {
        this.ensureCacheValid();
        int start = 0;
        int n = this.mPartitions.size();
        for (int i = 0; i < n; ++i) {
            int end = start + this.mPartitions.get((int)i).count;
            if (position >= start && position < end) {
                return i;
            }
            start = end;
        }
        return -1;
    }

    public int getOffsetInPartition(int position) {
        this.ensureCacheValid();
        int start = 0;
        for (Partition partition : this.mPartitions) {
            int end = start + partition.count;
            if (position >= start && position < end) {
                int offset = position - start;
                if (partition.hasHeader) {
                    --offset;
                }
                return offset;
            }
            start = end;
        }
        return -1;
    }

    public int getPositionForPartition(int partition) {
        this.ensureCacheValid();
        int position = 0;
        for (int i = 0; i < partition; ++i) {
            position += this.mPartitions.get((int)i).count;
        }
        return position;
    }

    public int getViewTypeCount() {
        return this.getItemViewTypeCount() + 1;
    }

    public int getItemViewTypeCount() {
        return 1;
    }

    protected int getItemViewType(int partition, int position) {
        return 1;
    }

    public int getItemViewType(int position) {
        this.ensureCacheValid();
        int start = 0;
        int n = this.mPartitions.size();
        for (int i = 0; i < n; ++i) {
            int end = start + this.mPartitions.get((int)i).count;
            if (position >= start && position < end) {
                int offset = position - start;
                if (this.mPartitions.get((int)i).hasHeader) {
                    --offset;
                }
                if (offset == -1) {
                    return -1;
                }
                return this.getItemViewType(i, offset);
            }
            start = end;
        }
        throw new ArrayIndexOutOfBoundsException(position);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        this.ensureCacheValid();
        int start = 0;
        int n = this.mPartitions.size();
        for (int i = 0; i < n; ++i) {
            int end = start + this.mPartitions.get((int)i).count;
            if (position >= start && position < end) {
                View view;
                int offset = position - start;
                if (this.mPartitions.get((int)i).hasHeader) {
                    --offset;
                }
                if (offset == -1) {
                    view = this.getHeaderView(i, this.mPartitions.get((int)i).cursor, convertView, parent);
                } else {
                    if (!this.mPartitions.get((int)i).cursor.moveToPosition(offset)) {
                        throw new IllegalStateException("Couldn't move cursor to position " + offset);
                    }
                    view = this.getView(i, this.mPartitions.get((int)i).cursor, offset, convertView, parent);
                }
                if (view == null) {
                    throw new NullPointerException("View should not be null, partition: " + i + " position: " + offset);
                }
                return view;
            }
            start = end;
        }
        throw new ArrayIndexOutOfBoundsException(position);
    }

    protected View getHeaderView(int partition, Cursor cursor, View convertView, ViewGroup parent) {
        View view = convertView != null ? convertView : this.newHeaderView(this.mContext, partition, cursor, parent);
        this.bindHeaderView(view, partition, cursor);
        return view;
    }

    protected View newHeaderView(Context context, int partition, Cursor cursor, ViewGroup parent) {
        return null;
    }

    protected void bindHeaderView(View view, int partition, Cursor cursor) {
    }

    protected View getView(int partition, Cursor cursor, int position, View convertView, ViewGroup parent) {
        View view = convertView != null ? convertView : this.newView(this.mContext, partition, cursor, position, parent);
        this.bindView(view, partition, cursor, position);
        return view;
    }

    protected abstract View newView(Context var1, int var2, Cursor var3, int var4, ViewGroup var5);

    protected abstract void bindView(View var1, int var2, Cursor var3, int var4);

    public Object getItem(int position) {
        this.ensureCacheValid();
        int start = 0;
        for (Partition mPartition : this.mPartitions) {
            int end = start + mPartition.count;
            if (position >= start && position < end) {
                int offset = position - start;
                if (mPartition.hasHeader) {
                    --offset;
                }
                if (offset == -1) {
                    return null;
                }
                Cursor cursor = mPartition.cursor;
                cursor.moveToPosition(offset);
                return cursor;
            }
            start = end;
        }
        return null;
    }

    public long getItemId(int position) {
        this.ensureCacheValid();
        int start = 0;
        for (Partition mPartition : this.mPartitions) {
            int end = start + mPartition.count;
            if (position >= start && position < end) {
                int offset = position - start;
                if (mPartition.hasHeader) {
                    --offset;
                }
                if (offset == -1) {
                    return 0L;
                }
                if (mPartition.idColumnIndex == -1) {
                    return 0L;
                }
                Cursor cursor = mPartition.cursor;
                if (cursor == null || cursor.isClosed() || !cursor.moveToPosition(offset)) {
                    return 0L;
                }
                return cursor.getLong(mPartition.idColumnIndex);
            }
            start = end;
        }
        return 0L;
    }

    public boolean areAllItemsEnabled() {
        for (Partition mPartition : this.mPartitions) {
            if (!mPartition.hasHeader) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabled(int position) {
        this.ensureCacheValid();
        int start = 0;
        int n = this.mPartitions.size();
        for (int i = 0; i < n; ++i) {
            int end = start + this.mPartitions.get((int)i).count;
            if (position >= start && position < end) {
                int offset = position - start;
                if (this.mPartitions.get((int)i).hasHeader && offset == 0) {
                    return false;
                }
                return this.isEnabled(i, offset);
            }
            start = end;
        }
        return false;
    }

    protected boolean isEnabled(int partition, int position) {
        return true;
    }

    public void setNotificationsEnabled(boolean flag) {
        this.mNotificationsEnabled = flag;
        if (flag && this.mNotificationNeeded) {
            this.notifyDataSetChanged();
        }
    }

    public void notifyDataSetChanged() {
        if (this.mNotificationsEnabled) {
            this.mNotificationNeeded = false;
            super.notifyDataSetChanged();
        } else {
            this.mNotificationNeeded = true;
        }
    }

    public static class Partition {
        boolean showIfEmpty;
        boolean hasHeader;
        Cursor cursor;
        int idColumnIndex;
        int count;

        public Partition(boolean showIfEmpty, boolean hasHeader) {
            this.showIfEmpty = showIfEmpty;
            this.hasHeader = hasHeader;
        }

        public boolean getShowIfEmpty() {
            return this.showIfEmpty;
        }

        public boolean getHasHeader() {
            return this.hasHeader;
        }

        public boolean isEmpty() {
            return this.count == 0;
        }
    }
}

