/*
 * Decompiled with CFR 0.152.
 */
package com.android.common.widget;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.os.Handler;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;

public abstract class GroupingListAdapter
extends BaseAdapter {
    private static final int GROUP_METADATA_ARRAY_INITIAL_SIZE = 16;
    private static final int GROUP_METADATA_ARRAY_INCREMENT = 128;
    private static final long GROUP_OFFSET_MASK = 0xFFFFFFFFL;
    private static final long GROUP_SIZE_MASK = 0x7FFFFFFF00000000L;
    private static final long EXPANDED_GROUP_MASK = Long.MIN_VALUE;
    public static final int ITEM_TYPE_STANDALONE = 0;
    public static final int ITEM_TYPE_GROUP_HEADER = 1;
    public static final int ITEM_TYPE_IN_GROUP = 2;
    private Context mContext;
    private Cursor mCursor;
    private int mCount;
    private int mRowIdColumnIndex;
    private int mGroupCount;
    private long[] mGroupMetadata;
    private SparseIntArray mPositionCache = new SparseIntArray();
    private int mLastCachedListPosition;
    private int mLastCachedCursorPosition;
    private int mLastCachedGroup;
    private PositionMetadata mPositionMetadata = new PositionMetadata();
    protected ContentObserver mChangeObserver = new ContentObserver(new Handler()){

        public boolean deliverSelfNotifications() {
            return true;
        }

        public void onChange(boolean selfChange) {
            GroupingListAdapter.this.onContentChanged();
        }
    };
    protected DataSetObserver mDataSetObserver = new DataSetObserver(){

        public void onChanged() {
            GroupingListAdapter.this.notifyDataSetChanged();
        }

        public void onInvalidated() {
            GroupingListAdapter.this.notifyDataSetInvalidated();
        }
    };

    public GroupingListAdapter(Context context) {
        this.mContext = context;
        this.resetCache();
    }

    protected abstract void addGroups(Cursor var1);

    protected abstract View newStandAloneView(Context var1, ViewGroup var2);

    protected abstract void bindStandAloneView(View var1, Context var2, Cursor var3);

    protected abstract View newGroupView(Context var1, ViewGroup var2);

    protected abstract void bindGroupView(View var1, Context var2, Cursor var3, int var4, boolean var5);

    protected abstract View newChildView(Context var1, ViewGroup var2);

    protected abstract void bindChildView(View var1, Context var2, Cursor var3);

    private void resetCache() {
        this.mCount = -1;
        this.mLastCachedListPosition = -1;
        this.mLastCachedCursorPosition = -1;
        this.mLastCachedGroup = -1;
        this.mPositionMetadata.listPosition = -1;
        this.mPositionCache.clear();
    }

    protected void onContentChanged() {
    }

    public void changeCursor(Cursor cursor) {
        if (cursor == this.mCursor) {
            return;
        }
        if (this.mCursor != null) {
            this.mCursor.unregisterContentObserver(this.mChangeObserver);
            this.mCursor.unregisterDataSetObserver(this.mDataSetObserver);
            this.mCursor.close();
        }
        this.mCursor = cursor;
        this.resetCache();
        this.findGroups();
        if (cursor != null) {
            cursor.registerContentObserver(this.mChangeObserver);
            cursor.registerDataSetObserver(this.mDataSetObserver);
            this.mRowIdColumnIndex = cursor.getColumnIndexOrThrow("_id");
            this.notifyDataSetChanged();
        } else {
            this.notifyDataSetInvalidated();
        }
    }

    public Cursor getCursor() {
        return this.mCursor;
    }

    private void findGroups() {
        this.mGroupCount = 0;
        this.mGroupMetadata = new long[16];
        if (this.mCursor == null) {
            return;
        }
        this.addGroups(this.mCursor);
    }

    protected void addGroup(int cursorPosition, int size, boolean expanded) {
        if (this.mGroupCount >= this.mGroupMetadata.length) {
            int newSize = this.idealLongArraySize(this.mGroupMetadata.length + 128);
            long[] array = new long[newSize];
            System.arraycopy(this.mGroupMetadata, 0, array, 0, this.mGroupCount);
            this.mGroupMetadata = array;
        }
        long metadata = (long)size << 32 | (long)cursorPosition;
        if (expanded) {
            metadata |= Long.MIN_VALUE;
        }
        this.mGroupMetadata[this.mGroupCount++] = metadata;
    }

    private int idealLongArraySize(int need) {
        return this.idealByteArraySize(need * 8) / 8;
    }

    private int idealByteArraySize(int need) {
        for (int i = 4; i < 32; ++i) {
            if (need > (1 << i) - 12) continue;
            return (1 << i) - 12;
        }
        return need;
    }

    public int getCount() {
        if (this.mCursor == null) {
            return 0;
        }
        if (this.mCount != -1) {
            return this.mCount;
        }
        int cursorPosition = 0;
        int count = 0;
        for (int i = 0; i < this.mGroupCount; ++i) {
            long metadata = this.mGroupMetadata[i];
            int offset = (int)(metadata & 0xFFFFFFFFL);
            boolean expanded = (metadata & Long.MIN_VALUE) != 0L;
            int size = (int)((metadata & 0x7FFFFFFF00000000L) >> 32);
            count += offset - cursorPosition;
            count = expanded ? (count += size + 1) : ++count;
            cursorPosition = offset + size;
        }
        this.mCount = count + this.mCursor.getCount() - cursorPosition;
        return this.mCount;
    }

    public void obtainPositionMetadata(PositionMetadata metadata, int position) {
        if (metadata.listPosition == position) {
            return;
        }
        int listPosition = 0;
        int cursorPosition = 0;
        int firstGroupToCheck = 0;
        if (this.mLastCachedListPosition != -1) {
            if (position <= this.mLastCachedListPosition) {
                int index = this.mPositionCache.indexOfKey(position);
                if (index < 0 && (index = ~index - 1) >= this.mPositionCache.size()) {
                    --index;
                }
                if (index >= 0) {
                    listPosition = this.mPositionCache.keyAt(index);
                    firstGroupToCheck = this.mPositionCache.valueAt(index);
                    long descriptor = this.mGroupMetadata[firstGroupToCheck];
                    cursorPosition = (int)(descriptor & 0xFFFFFFFFL);
                }
            } else {
                firstGroupToCheck = this.mLastCachedGroup;
                listPosition = this.mLastCachedListPosition;
                cursorPosition = this.mLastCachedCursorPosition;
            }
        }
        for (int i = firstGroupToCheck; i < this.mGroupCount; ++i) {
            long group = this.mGroupMetadata[i];
            int offset = (int)(group & 0xFFFFFFFFL);
            listPosition += offset - cursorPosition;
            cursorPosition = offset;
            if (i > this.mLastCachedGroup) {
                this.mPositionCache.append(listPosition, i);
                this.mLastCachedListPosition = listPosition;
                this.mLastCachedCursorPosition = cursorPosition;
                this.mLastCachedGroup = i;
            }
            if (position < listPosition) {
                metadata.itemType = 0;
                metadata.cursorPosition = cursorPosition - (listPosition - position);
                return;
            }
            boolean expanded = (group & Long.MIN_VALUE) != 0L;
            int size = (int)((group & 0x7FFFFFFF00000000L) >> 32);
            if (position == listPosition) {
                metadata.itemType = 1;
                metadata.groupPosition = i;
                metadata.isExpanded = expanded;
                metadata.childCount = size;
                metadata.cursorPosition = offset;
                return;
            }
            if (expanded) {
                if (position < listPosition + size + 1) {
                    metadata.itemType = 2;
                    metadata.cursorPosition = cursorPosition + (position - listPosition) - 1;
                    return;
                }
                listPosition += size + 1;
            } else {
                ++listPosition;
            }
            cursorPosition += size;
        }
        metadata.itemType = 0;
        metadata.cursorPosition = cursorPosition + (position - listPosition);
    }

    public boolean isGroupHeader(int position) {
        this.obtainPositionMetadata(this.mPositionMetadata, position);
        return this.mPositionMetadata.itemType == 1;
    }

    public int getGroupSize(int position) {
        this.obtainPositionMetadata(this.mPositionMetadata, position);
        return this.mPositionMetadata.childCount;
    }

    public void toggleGroup(int position) {
        this.obtainPositionMetadata(this.mPositionMetadata, position);
        if (this.mPositionMetadata.itemType != 1) {
            throw new IllegalArgumentException("Not a group at position " + position);
        }
        if (this.mPositionMetadata.isExpanded) {
            int n = this.mPositionMetadata.groupPosition;
            this.mGroupMetadata[n] = this.mGroupMetadata[n] & Long.MAX_VALUE;
        } else {
            int n = this.mPositionMetadata.groupPosition;
            this.mGroupMetadata[n] = this.mGroupMetadata[n] | Long.MIN_VALUE;
        }
        this.resetCache();
        this.notifyDataSetChanged();
    }

    public int getViewTypeCount() {
        return 3;
    }

    public int getItemViewType(int position) {
        this.obtainPositionMetadata(this.mPositionMetadata, position);
        return this.mPositionMetadata.itemType;
    }

    public Object getItem(int position) {
        if (this.mCursor == null) {
            return null;
        }
        this.obtainPositionMetadata(this.mPositionMetadata, position);
        if (this.mCursor.moveToPosition(this.mPositionMetadata.cursorPosition)) {
            return this.mCursor;
        }
        return null;
    }

    public long getItemId(int position) {
        Object item = this.getItem(position);
        if (item != null) {
            return this.mCursor.getLong(this.mRowIdColumnIndex);
        }
        return -1L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        this.obtainPositionMetadata(this.mPositionMetadata, position);
        View view = convertView;
        if (view == null) {
            switch (this.mPositionMetadata.itemType) {
                case 0: {
                    view = this.newStandAloneView(this.mContext, parent);
                    break;
                }
                case 1: {
                    view = this.newGroupView(this.mContext, parent);
                    break;
                }
                case 2: {
                    view = this.newChildView(this.mContext, parent);
                }
            }
        }
        this.mCursor.moveToPosition(this.mPositionMetadata.cursorPosition);
        switch (this.mPositionMetadata.itemType) {
            case 0: {
                this.bindStandAloneView(view, this.mContext, this.mCursor);
                break;
            }
            case 1: {
                this.bindGroupView(view, this.mContext, this.mCursor, this.mPositionMetadata.childCount, this.mPositionMetadata.isExpanded);
                break;
            }
            case 2: {
                this.bindChildView(view, this.mContext, this.mCursor);
            }
        }
        return view;
    }

    protected static class PositionMetadata {
        int itemType;
        boolean isExpanded;
        int cursorPosition;
        int childCount;
        private int groupPosition;
        private int listPosition = -1;

        protected PositionMetadata() {
        }
    }
}

