/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.api;

import android.app.Application;
import com.laputapp.Laputapp;
import com.laputapp.R;
import com.laputapp.api.ApiHeaders;
import com.squareup.okhttp.Cache;
import com.squareup.okhttp.OkHttpClient;
import java.io.File;
import java.util.MissingResourceException;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;

public class ApiService {
    public static final String API_URL = Laputapp.getAppResources().getString(R.string.api_url);
    private static ApiService sInstance;
    private boolean isDebug;
    private RestAdapter restAdapter;
    private ApiHeaders mApiHeaders;
    static final int DISK_CACHE_SIZE = 0x3200000;

    public static synchronized ApiService getInstance() {
        if (sInstance == null) {
            sInstance = new ApiService();
            sInstance.setIsDebug(false);
        }
        return sInstance;
    }

    public ApiService setIsDebug(boolean isDebug) {
        this.isDebug = isDebug;
        if (this.restAdapter != null) {
            this.restAdapter.setLogLevel(isDebug ? RestAdapter.LogLevel.FULL : RestAdapter.LogLevel.NONE);
        }
        return this;
    }

    private ApiHeaders getApiHeaders() {
        if (this.mApiHeaders == null) {
            this.mApiHeaders = new ApiHeaders();
        }
        return this.mApiHeaders;
    }

    private Client getClient() {
        return new OkClient(ApiService.createOkHttpClient(Laputapp.getInstance()));
    }

    static OkHttpClient createOkHttpClient(Application app) {
        OkHttpClient client = new OkHttpClient();
        File cacheDir = new File(app.getCacheDir(), "http");
        Cache cache = new Cache(cacheDir, 0x3200000L);
        client.setCache(cache);
        return client;
    }

    protected RestAdapter.Builder newRestAdapterBuilder() {
        return new RestAdapter.Builder();
    }

    protected RestAdapter getRestAdapter() {
        if (this.restAdapter == null) {
            try {
                RestAdapter.Builder builder = this.newRestAdapterBuilder();
                builder.setClient(this.getClient());
                builder.setEndpoint(API_URL);
                builder.setRequestInterceptor((RequestInterceptor)this.getApiHeaders());
                if (this.isDebug) {
                    builder.setLogLevel(RestAdapter.LogLevel.FULL);
                }
                this.restAdapter = builder.build();
            }
            catch (NullPointerException e) {
                throw new MissingResourceException("Define your endpoint in api_url string resource.", this.getClass().getName(), "api_url");
            }
        }
        return this.restAdapter;
    }

    public static <T> T create(Class<T> service) {
        return (T)ApiService.getInstance().getRestAdapter().create(service);
    }
}

