/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.configs;

import android.content.Context;
import com.facebook.cache.disk.DiskCacheConfig;
import com.facebook.common.internal.Supplier;
import com.facebook.imagepipeline.backends.okhttp.OkHttpImagePipelineConfigFactory;
import com.facebook.imagepipeline.cache.MemoryCacheParams;
import com.facebook.imagepipeline.core.ImagePipelineConfig;
import com.laputapp.configs.ConfigConstants;
import com.squareup.okhttp.OkHttpClient;

public class ImagePipelineConfigFactory {
    private static final String IMAGE_PIPELINE_CACHE_DIR = "imagepipeline_cache";
    private static ImagePipelineConfig sImagePipelineConfig;
    private static ImagePipelineConfig sOkHttpImagePipelineConfig;

    public static ImagePipelineConfig getImagePipelineConfig(Context context) {
        if (sImagePipelineConfig == null) {
            ImagePipelineConfig.Builder configBuilder = ImagePipelineConfig.newBuilder((Context)context);
            ImagePipelineConfigFactory.configureCaches(configBuilder, context);
            sImagePipelineConfig = configBuilder.build();
        }
        return sImagePipelineConfig;
    }

    public static ImagePipelineConfig getOkHttpImagePipelineConfig(Context context) {
        if (sOkHttpImagePipelineConfig == null) {
            OkHttpClient okHttpClient = new OkHttpClient();
            ImagePipelineConfig.Builder configBuilder = OkHttpImagePipelineConfigFactory.newBuilder((Context)context, (OkHttpClient)okHttpClient);
            ImagePipelineConfigFactory.configureCaches(configBuilder, context);
            sOkHttpImagePipelineConfig = configBuilder.build();
        }
        return sOkHttpImagePipelineConfig;
    }

    private static void configureCaches(ImagePipelineConfig.Builder configBuilder, Context context) {
        final MemoryCacheParams bitmapCacheParams = new MemoryCacheParams(ConfigConstants.MAX_MEMORY_CACHE_SIZE, Integer.MAX_VALUE, ConfigConstants.MAX_MEMORY_CACHE_SIZE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        configBuilder.setBitmapMemoryCacheParamsSupplier((Supplier)new Supplier<MemoryCacheParams>(){

            public MemoryCacheParams get() {
                return bitmapCacheParams;
            }
        }).setMainDiskCacheConfig(DiskCacheConfig.newBuilder().setBaseDirectoryPath(context.getApplicationContext().getCacheDir()).setBaseDirectoryName(IMAGE_PIPELINE_CACHE_DIR).setMaxCacheSize(0x2800000L).build());
    }
}

