/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.ui;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.inputmethod.InputMethodManager;
import butterknife.ButterKnife;
import com.laputapp.R;
import com.laputapp.analytics.AnalyticsActivity;
import com.laputapp.utilities.InputMethodUtils;
import com.laputapp.widget.ProgressLoading;

public class BaseActivity
extends AnalyticsActivity {
    private ProgressLoading mProgressLoading;
    private ProgressLoading mUnBackProgressLoading;
    private boolean progressShow;

    protected void onDestroy() {
        super.onDestroy();
        ButterKnife.unbind((Object)this);
        if (this.isProgressShow() && this.mProgressLoading != null) {
            this.dismissProgressLoading();
            this.mProgressLoading = null;
        }
    }

    private void bindViews() {
        ButterKnife.bind((Activity)this);
    }

    public void showProgressLoading(int resId) {
        this.showProgressLoading(this.getString(resId));
    }

    public void showProgressLoading(String message) {
        if (this.mProgressLoading == null) {
            this.mProgressLoading = new ProgressLoading((Context)this, R.style.ProgressLoadingTheme);
            this.mProgressLoading.setCanceledOnTouchOutside(true);
            this.mProgressLoading.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    BaseActivity.this.progressShow = false;
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)message)) {
            this.mProgressLoading.setMessage(message);
        } else {
            this.mProgressLoading.setMessage(null);
        }
        this.progressShow = true;
        this.mProgressLoading.show();
    }

    public boolean isProgressShow() {
        return this.progressShow;
    }

    public void dismissProgressLoading() {
        if (this.mProgressLoading != null && !this.isFinishing()) {
            this.progressShow = false;
            this.mProgressLoading.dismiss();
        }
    }

    public void showUnBackProgressLoading(int resId) {
        this.showUnBackProgressLoading(this.getString(resId));
    }

    public void showUnBackProgressLoading(String message) {
        if (this.mUnBackProgressLoading == null) {
            this.mUnBackProgressLoading = new ProgressLoading((Context)this, R.style.ProgressLoadingTheme){

                public void onBackPressed() {
                }
            };
        }
        if (!TextUtils.isEmpty((CharSequence)message)) {
            this.mUnBackProgressLoading.setMessage(message);
        } else {
            this.mUnBackProgressLoading.setMessage(null);
        }
        this.mUnBackProgressLoading.show();
    }

    public void dismissUnBackProgressLoading() {
        if (this.mUnBackProgressLoading != null && !this.isFinishing()) {
            this.mUnBackProgressLoading.dismiss();
        }
    }

    public static Bundle intentToFragmentArguments(Intent intent) {
        Bundle extras;
        Bundle arguments = new Bundle();
        if (intent == null) {
            return arguments;
        }
        Uri data = intent.getData();
        if (data != null) {
            arguments.putParcelable("_uri", (Parcelable)data);
        }
        if ((extras = intent.getExtras()) != null) {
            arguments.putAll(intent.getExtras());
        }
        return arguments;
    }

    public static Intent fragmentArgumentsToIntent(Bundle arguments) {
        Intent intent = new Intent();
        if (arguments == null) {
            return intent;
        }
        Uri data = (Uri)arguments.getParcelable("_uri");
        if (data != null) {
            intent.setData(data);
        }
        intent.putExtras(arguments);
        intent.removeExtra("_uri");
        return intent;
    }

    public void hideSoftInputMethod() {
        try {
            InputMethodUtils.hideSoftInputMethod((Context)this, this.getCurrentFocus().getWindowToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void finish() {
        this.hideSoftInputMethod();
        super.finish();
    }

    public void showSoftInputMethod() {
        try {
            InputMethodUtils.showSoftInputMethod((Context)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isImmActive() {
        try {
            InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
            return imm.isActive();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

