/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.ui;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.laputapp.http.Callbacks;
import com.laputapp.http.DataLoader;
import com.laputapp.http.Response;
import com.laputapp.ui.CollectionFragment;
import com.laputapp.utilities.Lists;
import com.laputapp.widget.CollectionView;
import com.laputapp.widget.CollectionViewCallbacks;
import java.util.ArrayList;
import retrofit.RetrofitError;

public abstract class BaseCollectionFragment<T>
extends CollectionFragment
implements Callbacks.RequestCallback<ArrayList<T>>,
CollectionViewCallbacks,
DataLoader.Loader<T>,
DataLoader.KeyExtractor<T> {
    protected static final int GROUP_ID_NORMAL = 10001;
    protected ArrayList<T> mItems = Lists.newArrayList();
    private DataLoader<T> mDataLoader;
    private boolean mDataIsFullReload;
    protected boolean hasWarned = false;
    private boolean mDataHasLoaded = false;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mDataLoader = new DataLoader((DataLoader.Loader)this, (Callbacks.RequestCallback)this, (DataLoader.KeyExtractor)this);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (!this.mItems.isEmpty()) {
            this.updateCollectionView();
        }
        if (!this.mDataHasLoaded) {
            this.mDataLoader.refresh();
        }
    }

    protected void updateCollectionView() {
        if (this.getView() == null) {
            return;
        }
        int itemCount = this.mItems.size();
        CollectionView.Inventory inv = itemCount == 0 ? this.prepareNoDataInventory() : this.newInventory();
        Parcelable state = null;
        if (!this.mDataIsFullReload) {
            state = this.getListView().onSaveInstanceState();
        }
        this.getListView().setCollectionAdapter(this);
        this.getListView().updateInventory(this, inv, this.mDataIsFullReload);
        if (state != null) {
            this.getListView().onRestoreInstanceState(state);
        }
        this.mDataIsFullReload = false;
        this.hasWarned = false;
    }

    protected CollectionView.Inventory prepareNoDataInventory() {
        return new CollectionView.Inventory();
    }

    protected boolean showCollectionViewHeader() {
        return false;
    }

    protected CollectionView.Inventory prepareInventory() {
        return new CollectionView.Inventory();
    }

    public DataLoader<T> getDataLoader() {
        return this.mDataLoader;
    }

    protected int getCollectionViewDisplayCols() {
        return 1;
    }

    protected CollectionView.Inventory newInventory() {
        CollectionView.InventoryGroup curGroup = null;
        CollectionView.Inventory inventory = this.prepareInventory();
        int normalColumns = this.getCollectionViewDisplayCols();
        int size = this.mItems.size();
        for (int dataIndex = 0; dataIndex < size; ++dataIndex) {
            if (curGroup == null) {
                curGroup = new CollectionView.InventoryGroup(10001).setDataIndexStart(dataIndex).setShowHeader(this.showCollectionViewHeader()).setDisplayCols(normalColumns).setItemCount(1);
                continue;
            }
            curGroup.incrementItemCount();
        }
        if (curGroup != null) {
            inventory.addGroup(curGroup);
        }
        return inventory;
    }

    @Override
    public View newCollectionHeaderView(Context context, ViewGroup parent) {
        return null;
    }

    @Override
    public void bindCollectionHeaderView(Context context, View view, int groupId, String headerLabel) {
    }

    public void beforeRefresh() {
    }

    public void beforeLoadMore() {
    }

    public T register(T resource) {
        return resource;
    }

    public void onRequestComplete(Response<ArrayList<T>> response) {
        this.mItems = this.mDataLoader.getResources();
        this.mDataHasLoaded = !this.mItems.isEmpty();
    }

    public void onRequestFailure(Response<ArrayList<T>> response) {
        this.mDataHasLoaded = false;
    }

    public void onRequestFailure(RetrofitError error) {
        this.mDataHasLoaded = false;
    }

    public void onRequestNetworkError() {
        this.mDataHasLoaded = false;
    }

    public void onFinish() {
        this.updateCollectionView();
    }

    public boolean canCache() {
        return false;
    }

    public void handleLocalCache(ArrayList<T> data) {
    }

    public void onCacheLoaded(ArrayList<T> localData) {
        if (localData == null || localData.isEmpty()) {
            return;
        }
        for (T data : localData) {
            this.register(data);
        }
        this.mItems.addAll(localData);
        if (!this.mItems.isEmpty()) {
            this.updateCollectionView();
        }
    }
}

