/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.ui;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.AbsListView;
import com.laputapp.ui.BaseCollectionFragment;
import com.laputapp.widget.ResourceLoadingIndicator;

public abstract class BasePagedCollectionFragment<T>
extends BaseCollectionFragment<T>
implements AbsListView.OnScrollListener {
    private ResourceLoadingIndicator mLoadingIndicator;

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mLoadingIndicator = new ResourceLoadingIndicator((Context)this.getActivity());
        this.mLoadingIndicator.setList(this.getListView());
        this.getListView().setOnScrollListener(this);
    }

    @Override
    public void onFinish() {
        super.onFinish();
        this.mLoadingIndicator.setVisible(this.getDataLoader().hasMore());
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
    }

    protected boolean isUsable() {
        return this.getActivity() != null && !this.getActivity().isFinishing();
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (!this.isUsable() || this.hasWarned || !this.getDataLoader().canLoadMore() || totalItemCount == 0 || view.getLastVisiblePosition() != totalItemCount - 1) {
            return;
        }
        this.hasWarned = true;
        if (this.getListView() != null && (long)this.getListView().getLastVisiblePosition() >= this.getDataLoader().size()) {
            this.getDataLoader().loadMore();
        }
    }
}

