/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.ui;

import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewStub;
import com.laputapp.R;
import com.laputapp.ui.RecyclerFragment;
import com.laputapp.utilities.UiUtilities;
import java.lang.ref.WeakReference;

public abstract class PagedRecyclerFragment<T>
extends RecyclerFragment<T> {
    private WeakScrollListener scrollListener;
    ViewStub mLoadMore;
    private View mLoadMoreView;
    private boolean hasWarned = false;

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mLoadMore = (ViewStub)UiUtilities.getView(view, R.id.view_load_more);
        RecyclerView recyclerView = this.getRecyclerView();
        this.scrollListener = new WeakScrollListener((LinearLayoutManager)recyclerView.getLayoutManager(), this);
        recyclerView.setOnScrollListener((RecyclerView.OnScrollListener)this.scrollListener);
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.scrollListener);
        this.mLoadMore.setLayoutResource(R.layout.view_load_more);
        this.mLoadMoreView = this.mLoadMore.inflate();
        this.hideMoreProgress();
    }

    public void onDestroyView() {
        RecyclerView recyclerView = this.getRecyclerView();
        if (recyclerView != null && this.scrollListener != null) {
            recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this.scrollListener);
        }
        super.onDestroyView();
    }

    public void showMoreProgress() {
        this.mLoadMore.setVisibility(0);
    }

    public void hideMoreProgress() {
        this.mLoadMore.setVisibility(8);
    }

    @Override
    public void onFinish() {
        super.onFinish();
        if (this.getDataLoader().isLoadMore()) {
            this.hideMoreProgress();
        }
    }

    @Override
    protected void updateRecyclerView() {
        super.updateRecyclerView();
        this.hasWarned = false;
    }

    private static class WeakScrollListener
    extends RecyclerView.OnScrollListener {
        private static final int VISIBLE_THRESHOLD = 1;
        private final WeakReference<PagedRecyclerFragment> mTarget;
        private final LinearLayoutManager mLayoutManager;

        public WeakScrollListener(LinearLayoutManager layoutManager, PagedRecyclerFragment target) {
            this.mLayoutManager = layoutManager;
            this.mTarget = new WeakReference<PagedRecyclerFragment>(target);
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            LinearLayoutManager layoutManager = this.mLayoutManager;
            int visibleItemCount = recyclerView.getChildCount();
            int totalItemCount = layoutManager.getItemCount();
            int firstVisibleItemPosition = layoutManager.findFirstVisibleItemPosition();
            PagedRecyclerFragment target = (PagedRecyclerFragment)this.mTarget.get();
            if (target == null) {
                return;
            }
            if (!target.isVisible() || target.hasWarned || !target.getDataLoader().canLoadMore() || totalItemCount == 0) {
                return;
            }
            if (totalItemCount - visibleItemCount <= firstVisibleItemPosition + 1 && (long)totalItemCount < target.getDataLoader().getTotalSize()) {
                this.onLoadMore();
            }
        }

        private void onLoadMore() {
            PagedRecyclerFragment target = (PagedRecyclerFragment)this.mTarget.get();
            if (target != null && target.getDataLoader() != null && target.getDataLoader().canLoadMore()) {
                target.showMoreProgress();
                target.hasWarned = true;
                target.getDataLoader().loadMore();
            }
        }
    }
}

