/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.ui;

import android.app.Activity;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewStub;
import com.laputapp.R;
import com.laputapp.ui.RecyclerPullBaseActivity;
import com.laputapp.utilities.UiUtilities;
import java.lang.ref.WeakReference;

public abstract class PagedRecyclerPullActivity<T>
extends RecyclerPullBaseActivity<T> {
    private WeakScrollListener scrollListener;
    ViewStub mLoadMore;
    private View mLoadMoreView;
    private boolean hasWarned = false;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mLoadMore = (ViewStub)UiUtilities.getView((Activity)this, R.id.view_load_more);
    }

    @Override
    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        RecyclerView recyclerView = this.getRecyclerView();
        this.scrollListener = new WeakScrollListener((LinearLayoutManager)recyclerView.getLayoutManager(), this);
        recyclerView.setOnScrollListener((RecyclerView.OnScrollListener)this.scrollListener);
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.scrollListener);
        this.mLoadMore.setLayoutResource(R.layout.view_load_more);
        this.mLoadMoreView = this.mLoadMore.inflate();
        this.hideMoreProgress();
    }

    protected void onStop() {
        super.onStop();
        RecyclerView recyclerView = this.getRecyclerView();
        if (recyclerView != null && this.scrollListener != null) {
            recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this.scrollListener);
        }
    }

    public void showMoreProgress() {
        this.mLoadMore.setVisibility(0);
    }

    public void hideMoreProgress() {
        this.mLoadMore.setVisibility(8);
    }

    @Override
    public void onFinish() {
        super.onFinish();
        if (this.getDataLoader().isLoadMore()) {
            this.hideMoreProgress();
        }
    }

    @Override
    protected void updateRecyclerView() {
        super.updateRecyclerView();
        this.hasWarned = false;
    }

    private static class WeakScrollListener
    extends RecyclerView.OnScrollListener {
        private static final int VISIBLE_THRESHOLD = 1;
        private final WeakReference<PagedRecyclerPullActivity> mTarget;
        private final LinearLayoutManager mLayoutManager;

        public WeakScrollListener(LinearLayoutManager layoutManager, PagedRecyclerPullActivity target) {
            this.mLayoutManager = layoutManager;
            this.mTarget = new WeakReference<PagedRecyclerPullActivity>(target);
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            LinearLayoutManager layoutManager = this.mLayoutManager;
            int visibleItemCount = recyclerView.getChildCount();
            int totalItemCount = layoutManager.getItemCount();
            int firstVisibleItemPosition = layoutManager.findFirstVisibleItemPosition();
            PagedRecyclerPullActivity target = (PagedRecyclerPullActivity)this.mTarget.get();
            if (target == null) {
                return;
            }
            if (target.isFinishing() || target.hasWarned || !target.getDataLoader().canLoadMore() || totalItemCount == 0) {
                return;
            }
            if (totalItemCount - visibleItemCount <= firstVisibleItemPosition + 1 && (long)totalItemCount < target.getDataLoader().getTotalSize()) {
                this.onLoadMore();
            }
        }

        private void onLoadMore() {
            PagedRecyclerPullActivity target = (PagedRecyclerPullActivity)this.mTarget.get();
            if (target != null && target.getDataLoader() != null && target.getDataLoader().canLoadMore()) {
                target.showMoreProgress();
                target.hasWarned = true;
                target.getDataLoader().loadMore();
            }
        }
    }
}

